class ExaminationsController < ApplicationController
  include ExamRequestUtility
  before_action :set_examination, only: [:show, :edit, :update, :destroy]
  skip_before_action :clear_current_site
  SCHEDULED_MESSAGE = "Please click the Start button to begin work on the diagnosis."
  RESCHEDULE_MESSAGE = "Examination is being rescheduled. Notification will be sent out upon completion."
  OTHER_MESSAGE = "This examination has not been scheduled yet. It can be worked on once it is scheduled."

  check_authorization
  authorize_resource
  # GET /examinations
  # GET /examinations.json
  def index
    @examinations = Examination.all
    puts params[:resp]
    if params[:resp] == 'n'
      flash[:notice] = "Examination has been successfully created."
    end
  end

  # GET /examinations/1
  # GET /examinations/1.json
  def show
  end

  # GET /examinations/new
  def new
    @examination = Examination.new
  end

  # GET /examinations/1/edit
  def edit

    #flash.clear
    @evaluation = Evaluation.find(@examination.evaluation_id)
    @claim = Claim.find(@evaluation.claim_id)
    er = ExamRequest.find(@examination.exam_request_id)
    prepare_data_for_full_exam_request(er)
    if params[:status].present?
      if params[:status] == "completed"
        @examination.examination_state = ExaminationState.find_by_code("COMPLETED")
        @examination.examination_state_start_date = DateTime.current

        @examination.save
        flash[:notice] = "Examination is now ready for review by supervising clinician."
        redirect_to dashboards_path
      elsif params[:status] == "reviewed"
        @examination.examination_state = ExaminationState.find_by_code("REVIEWED")
        @examination.examination_state_start_date = DateTime.current
        @examination.save

        #SEND EXAM RESPONSE TO DAS
        ExamResultsJob.perform_later(@examination.id)
        ContentionResultsPackageJob.set(wait: 5.minutes).perform_later(@examination.id)

        flash[:notice] = "Examination has been marked as 'Reviewed'."
        redirect_to dashboards_path
      end
    else
      #If examination is cancelled
      if (@examination.examination_state.code == "CANCELLED" && !@examination.acknowledged)
       # redirect_to "ep/acknowledge_examination/"+@exam.identifier && return
        #redirect_to :controller => :examination_processors, :action_name => :ack, :id => @exam.identifier
        redirect_to acknowledge_path(:id => @examination.identifier)
      end
    end
  end

  def create

    @examination = Examination.new
  end

  # POST /examinations
  # POST /examinations.json
  def create
    @examination = Examination.new(examination_params)

    respond_to do |format|
      if @examination.save
        format.html { redirect_to @examination, notice: 'Examination has been successfully created.' }
        format.json { render action: 'show', status: :created, location: @examination }
      else
        format.html { render action: 'new' }
        format.json { render json: @examination.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /examinations/1
  # PATCH/PUT /examinations/1.json
  def update
    if params[:dbq_for_exam_id].present?
      dbq = DbqForm.find(params[:dbq_for_exam_id])
      # Check that we're not re-adding dbqs already associated
      if !@examination.dbq_forms.pluck(:title).include? dbq.title
        dbq_for_exam = dbq.deep_dup
        dbq_for_exam.update_attribute(:template, false)
        @examination.dbq_forms << dbq_for_exam
        flash[:notice] = "DBQ Form has been succesfully added to the examination."      
      else
        flash[:alert] = "The selected DBQ has already been added to the examination."      
      end        
      redirect_to edit_examination_path(@examination)      
    elsif params[:start_examination]
      @examination = Examination.find(params[:id])
      @examination.examination_state = ExaminationState.find_by_code("IN_PROGRESS")
      @examination.examination_state_start_date = DateTime.current
      @examination.save
      flash[:notice] = "Examination has been successfully updated and can now be worked on."
      redirect_to edit_examination_path(@examination)
    elsif params[:examination][:examination_notes].present?
      note = ExaminationNote.create(from_id: current_user.id, to_id: nil, note: params[:examination][:examination_notes])
      @examination.examination_notes << note
      @examination.save
      flash[:notice] = "Your note has been added to the Examination Notes history."
      redirect_to edit_examination_path(@examination, tab: 'panel-5')
    elsif params[:examination][:examination_review_questionnaire_attributes].present?
      questionnaire = @examination.create_examination_review_questionnaire(questionnaire_params(params[:examination]))
      cleanup_questionnaire(questionnaire)
      flash[:notice] = "Your Pre-exam responses have been added to the examination results."
      redirect_to edit_examination_path(@examination)
    else
      respond_to do |format|
        if @examination.update( examination_params.except(:examination_notes))
          format.html { redirect_to edit_examination_path(@examination), notice: 'Examination has been successfully updated.' }
          format.json { head :no_content }
        else
          format.html { render action: 'edit' }
          format.json { render json: @examination.errors, status: :unprocessable_entity }
        end
      end
    end
  end

  # DELETE /examinations/1
  # DELETE /examinations/1.json
  def destroy
    @examination.destroy
    respond_to do |format|
      format.html { redirect_to examinations_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_examination
      @examination = Examination.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def examination_params
      params.require(:examination).permit(
        :title,
        :exam_date,
        :state,
        :exam_id,
        :clinician,
        :claim_folder_reviewed,
        :no_diagnosis,
        :reviewed_military_service_treatment_records,
        :reviewed_military_service_personnel_records,
        :reviewed_military_enlistment_examination,
        :reviewed_military_separation_examination,
        :reviewed_military_post_deployment_questionnaire,
        :reviewed_dod_form_214_separation_documents,
        :reviewed_vha_treatment_records,
        :reviewed_civilian_medical_records,
        :reviewed_interviews_with_collateral_witnesses,
        :reviewed_not_indicated,
        :interview,
        :plan,
        :examination_notes
      )
    end

    def questionnaire_params params
      params.require(:examination_review_questionnaire_attributes).permit(
        :claim_folder_reviewed,
        :reviewed_not_indicated,
        :reviewed_military_service_treatment_records,
        :reviewed_military_service_personnel_records,
        :reviewed_military_enlistment_examination,
        :reviewed_military_separation_examination,
        :reviewed_military_post_deployment_questionnaire,
        :reviewed_dod_form_214_separation_documents,
        :reviewed_vha_treatment_records,
        :reviewed_civilian_medical_records,
        :reviewed_interviews_with_collateral_witnesses,
        :not_requested,
        :va_claims_file,
        :va_e_folder,
        :cprs,
        :no_records_were_reviewed,
        :other,
        :other_text,
        :evidence_comments,
        :evidence_comments_text
        )
    end

    def cleanup_questionnaire qt
      if qt.claim_folder_reviewed?
        qt.reviewed_not_indicated = false
        qt.reviewed_military_service_treatment_records = false
        qt.reviewed_military_service_personnel_records = false
        qt.reviewed_military_enlistment_examination = false
        qt.reviewed_military_separation_examination = false
        qt.reviewed_military_post_deployment_questionnaire = false
        qt.reviewed_dod_form_214_separation_documents = false
        qt.reviewed_vha_treatment_records = false
        qt.reviewed_civilian_medical_records = false
        qt.reviewed_interviews_with_collateral_witnesses = false
      else
        qt.not_requested = false
        qt.va_claims_file = false
        qt.va_e_folder = false
        qt.cprs = false
        qt.no_records_were_reviewed = false
        qt.other = false
        qt.other_text = ""
        qt.evidence_comments = false
        qt.evidence_comments_text = ""
      end
      qt.save
    end
end
