class ExamfilesController < ApplicationController
  before_action :set_examination

  def create
    add_more_examfiles(examfiles_params[:examfiles])
    if @examination.save
      flash[:notice] = I18n.t('errors.messages.file_saved')
    else
      flash[:alert] = I18n.t('errors.messages.general_error')
    end
    redirect_to :back
  end

  def destroy
    remove_examfile_at_index(params[:id].to_i)
    if @examination.save
      flash[:notice] = I18n.t('errors.messages.file_removed')
    else
      flash[:alert] = I18n.t('errors.messages.file_removal_failed')
    end
    redirect_to :back
  end

  def serve
    if (can? :show, @examination) && @examination.examfiles.map{|f| f.file.basename}.include?(params[:filename])
      path = File.join(Rails.root, examfile_path)
      send_file path, :disposition => 'inline'
    else
      raise CanCan::AccessDenied
    end
  end

  private

  def set_examination
    @examination = Examination.find(params[:examination_id])
  end

  def add_more_examfiles(new_examfiles)
    examfiles = @examination.examfiles # copy the old examfiles
    examfiles += new_examfiles # concat old examfiles with new ones
    @examination.examfiles = examfiles # assign back
    if @examination.dbq_forms.present?
      new_examfiles.each do |n|
        @examination.examfiles_dbqs[@examination.examfiles_dbqs.count] = @examination.dbq_forms.first.id
      end
    end
  end

  def remove_examfile_at_index(index)
    if index == 0 && @examination.examfiles.count <= 1
      #This condition is needed because for some reason the delete_at() below is not working when just one file remains.
      @examination.remove_examfiles!
    else
      remain_examfiles = @examination.examfiles # copy the array
      deleted_examfile = remain_examfiles.delete_at(index) # delete the target examfile
      deleted_examfile.try(:remove!) # delete examfile from S3
      @examination.examfiles = remain_examfiles # re-assign back
    end
    @examination.examfiles_dbqs.delete_at(index)
  end

  def examfiles_params
    params.require(:examination).permit({examfiles: []}) # allow nested params as array
  end

end
