class ExamRequestController < ApplicationController
  include ClarificationHelper, ExamRequestStateHelper, ExamRequestUtility, ContentionHelper, DataTablePaginator
  before_action :get_exam_request, only: [:view_exam_request, :ack, :view_cancelled_exam_request]
  before_action :get_exam_request_using_er_id, only: [:ack_submit, :cancel_exam_request, :cancel_submit, :change_site, :get_clarification, :add_dbqs, :add_dbqs_submit, :cancel_dbqs, :cancel_dbqs_submit, :select_contentions_submit, :accept_clarification ]
  before_action :redirect_if_no_exam_request, only: [:view_exam_request, :cancel_submit, :view_cancelled_exam_request]
  check_authorization
  authorize_resource

  def index

  end

  def new
    @claim = Claim.new
    @contentions = @claim.contentions + [Contention.new]
    @all_sites = Site.all
    if @all_sites.present?
      @sites = @all_sites.map{ |s| [s.name, s.id] }
    end
  end

  def view_exam_request
    if (isExamRequestPendingCancellation(@exam_request.exam_request_state_id))
      redirect_to action: 'cancel_exam_request', er_id: @exam_request.identifier
    else
      prepareExamRequestData(@exam_request)

      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id).includes(:examination_schedules, :contentions).flatten.select{|e| e.examination_schedules.flatten.select{|es| es.active==true}}
      @contentions = loadContentions(@exam_request)
      @contention_rows = generate_associated_contentions(@contentions)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: @exam_request.id).order(created_at: :DESC))
      @clarification_details = @exam_request.contentions.collect {|con| con.clarification_details.where(clarification_type: 2)}.flatten
      @exam_request_on_hold = false
      if @exam_request.exam_request_state.code == "PENDING_CLARIFICATION"
        @exam_request_on_hold = true
        flash.now[:notice] = "This Exam Request is on hold due to a pending clarification request. Contact your VBA representative for a status."
      end
    end
  end

  def paged_erh_list
     erh_info_func = -> (erh) do
        {
          id:     erh.id,
          date:   erh.created_at.strftime("%B %e, %Y, %l:%M %p"),
          event:  erh.event,
          notes:  erh.notes
        }
      end
      er_id = params[:erId].to_i
      ordered_erh =  apply_ordering_to_query(ExamRequestHistory.where(exam_request_id: er_id).order(created_at: :DESC), ExamRequestHistory::FIELDS_FOR_RESULTSET)
      return_data = datatables_json_for_query_using_func(
        ordered_erh, erh_info_func
      ).to_json

      render json: return_data
  end

  def ack
    if (@exam_request.present? && @exam_request.exam_request_state.present? && @exam_request.exam_request_state.code == "CANCELLED")

      prepareExamRequestData(@exam_request)
      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id)
      @contentions = loadContentions(@exam_request)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: params[:id]).order(created_at: :DESC))
    else
      flash[:alert] = "Unable to locate the ExamRequest"
      redirect_to dashboards_path
    end
  end

  def ack_submit
    if (@exam_request.present? && @exam_request.exam_request_state.present? && @exam_request.exam_request_state.code == "CANCELLED")
      @exam_request.cancellation_acknowledged = true
      @exam_request.save

      notes = current_user.first_name + " " +current_user.last_name + " acknowledged the exam request cancellation"
      @exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes)
      @exam_request_history.save

      flash[:notice] = "Acknowledgement successful"
    else
      flash[:alert] = "Unable to locate the ExamRequest"
    end
    redirect_to dashboards_path
  end

  def cancel_dbqs

    prepareExamRequestData(@exam_request)
    @contentions = loadContentions(@exam_request)
    @contention_rows = generate_associated_contentions(@contentions)
  end

  def cancel_dbqs_submit

    selected_fields = params[:cancel_dbq_select]
    delete_comments = []

    begin

      ActiveRecord::Base.transaction do

        selected_fields.each do |row_id|

          ids = row_id.split('_')

          #ContentionsDbqInformation.where(contention_id: ids[0].to_i, dbq_information_id: ids[1].to_i).first.destroy!
          contention = Contention.find(ids[0].to_i)
          dbq_to_be_deleted = contention.dbq_informations.find(ids[1].to_i)
          contention.dbq_informations.delete(dbq_to_be_deleted)

          remarks = params['remarks_' + row_id]

          if remarks != ''
            remarks = ' (' + remarks + ')'
          end

          # need to replace line breaks in the DBQ title or the entire comment won't be added to the DB, not sure what is adding them to the strings
          delete_comments << current_user.first_name + ' ' + current_user.last_name + ' cancelled the DBQ "' + params['dbq_title_' + row_id].gsub(/\s+$/, '') + '" from the contention "' + params['contention_description_' + row_id] + '" for the reason: ' + params['cancel_reason_' + row_id] + remarks
        end

        delete_comments.each do |comment|
          ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: comment).save!
        end

      end

      flash[:notice] = 'DBQs have been successfully cancelled.'
      redirect_to action: 'view_exam_request', id: @exam_request.identifier.to_s

    rescue => e

      flash[:alert] = 'An error occurred and the DBQs have not been cancelled.'
      redirect_to action: 'cancel_dbqs', er_id: @exam_request.identifier.to_s
    end
  end

  def add_dbqs
    prepareExamRequestData(@exam_request)
  end

  def add_dbqs_submit

    selected_dbqs = params[:dbqs]
    contention_id = params[:contention_id].to_i
    contention_description = params[:contention_description]
    comments = current_user.first_name + ' ' + current_user.last_name + ' added the following DBQs to the contention "' + contention_description + '": '

    begin

      ActiveRecord::Base.transaction do

        selected_dbqs.each do |dbq|

          dbq = dbq.split('}}')
          #ContentionsDbqInformation.new(contention_id: contention_id, dbq_information_id: dbq[0].to_i).save!

          contention = Contention.find(contention_id)
          contention.dbq_informations << DbqInformation.find(dbq[0].to_i)

          # need to replace line breaks in the DBQ title or the entire comment won't be added to the DB, not sure what is adding them to the strings
          comments += '"' + dbq[1].gsub(/\s+$/, '') + '", '
        end

        ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: comments.chomp(', ')).save!

      end

      flash[:notice] = 'The DBQs have been successfully added to the contention.'
      redirect_to action: 'view_exam_request', id: @exam_request.identifier.to_s

    rescue => e

      flash[:alert] = 'An error occurred and the DBQs have not added to the contention.'
      redirect_to action: 'add_dbqs', er_id: @exam_request.identifier.to_s
    end

  end

  def cancelExamRequest
    prepareExamRequestData(@exam_request)

    render :cancel_exam_request
  end

  def cancel_submit
    if (isExamRequestPendingCancellation(@exam_request.exam_request_state_id))
      @exam_request.exam_request_state_id = getCancelledExamRequestStateId()
      @exam_request.save

      flash[:notice] = "Exam Request successfully cancelled"
      redirect_to dashboards_path
    end
  end

  def view_cancelled_exam_request
    if (isExamRequestCancelled(@exam_request.exam_request_state_id))
      prepareExamRequestData(@exam_request)

      @sites = Site.all
      @examinations = Examination.where(exam_request_id: @exam_request.id)
      @contentions = loadContentions(@exam_request)
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: params[:id]).order(created_at: :DESC))

    else
      flash[:alert] = "Unable to locate the Exam Request record."
      redirect_to dashboards_path
    end
  end

  def loadContentions(exam_request)
    @claim = Claim.find_by_id(exam_request.claim_id)
    @claim.contentions.includes(:contention_details)
  end

  def prepareExamRequestData(exam_request)
    @claim = Claim.find_by_id(exam_request.claim_id)
    request_object = RequestObject.find_by_claim_id exam_request.claim_id
    prepare_data_for_full_exam_request(exam_request)

    @contractorName = ""
    @gender = ""
    if request_object.present?
      request_object_doc = Nokogiri::XML(request_object.xml)

      @veteranServiceMemberInfo = XmlHelper.getDoc(request_object_doc, 'VeteranServiceMemberInfo')
      @gender = @veteranServiceMemberInfo['gender']

      @claimInformation = XmlHelper.getDoc(request_object_doc, 'PostDischargeClaimInformation')
      @claimDate = @claimInformation['claimDate']

      # is postSeparation the same as SeparationStatus?
      @postSeparation = @claimInformation['postSeparation']

      @benefitType = @claimInformation['benefitProgramType']

      @preferredGeographicLoc = XmlHelper.getDoc(request_object_doc, 'PreferredGeographicLocation')
      @PAddress = ""
      if (@preferredGeographicLoc != nil)
        @preferredAddress1 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address1').children.text
        @preferredAddress2 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address2').children.text
        @preferredAddress3 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address3').children.text
        @preferredAddress4 = XmlHelper.getDoc(@preferredGeographicLoc, 'Address1').children.text
        @preferredCity = XmlHelper.getDoc(@preferredGeographicLoc, 'City').children.text
        @preferredState = XmlHelper.getDoc(@preferredGeographicLoc, 'State').children.text
        @preferredZip = XmlHelper.getDoc(@preferredGeographicLoc, 'ZipOrPostalCode').children.text
        @PAddress = @preferredAddress1 + "\n" + @preferredCity + ",  " + @preferredState + "  " + @preferredZip
      end

      @examRelatedContentions = XmlHelper.getDoc(request_object_doc, 'ExamRelatedContentions')
      @contentionType = XmlHelper.getDoc(@examRelatedContentions, 'ExamRelatedContention')['contentionType']

    end
  end

  def get_clarification
    prepareExamRequestData(@exam_request)
    @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: @exam_request.id).order(created_at: :DESC))
    @examinations = Examination.where(exam_request_id: @exam_request.id)
                               .includes(:examination_schedules, :contentions)
                               .flatten.select{|e| e.examination_schedules.flatten.select{|es| es.active==true}}
    @contentions = loadContentions(@exam_request)
    @contention_rows = generate_associated_contentions(@contentions)
    @clarification_request = ClarificationRequest.new

    render :clarification_info
  end

  def clarification_info_submit
    @exam_request = ExamRequest.find_by_identifier(params['er_id'])
    @exam_request.set_exam_request_state "PENDING_CLARIFICATION"
    @clarification_request = ClarificationRequest.new
    selected_contention_ids = params[:clarification_contention_select]


    if selected_contention_ids.nil?
      selected_contention_ids = {}
    end

    @clarification_request.clarificationReason = params[:clarification_reason]
    @clarification_request.clarification_category = params[:clarification_category]
    @clarification_request.primary = params[:primary]
    @clarification_request.alternate = params[:alternate]

    @clarification_request.clarificationText = Hash.new

    if params[:clarification_reason] == 'Exam Request Related'
      first_contention = @exam_request.contentions.first
      @clarification_request.clarificationText[first_contention.exam_related_contention_id] = params[:clarification_comments]
    else

      selected_contention_ids.each do |contention_id|

        contention = Contention.find_by_id(contention_id)
        @clarification_request.clarificationText[contention.exam_related_contention_id] = params['contention_comments_' + contention_id.to_s]
      end
    end

    if params[:clarification_reason] == 'Contention Related'
      createContentionDetail(selected_contention_ids, @clarification_request)
    end
    # request_objects.sql need to be updated for buildAndSendClarificationRequestEvent to be functional.
    eventId = build_and_send_clarification_request_event(current_user, params['er_id'], selected_contention_ids, @clarification_request)

    flash[:notice] = 'Clarification Request sent successfully'
    uri = URI.parse('/erp/view_exam_request/' + @exam_request.identifier.to_s)
    redirect_to uri.to_s
  end

  def createContentionDetail(selectedContentionIds, clarificationRequest)
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)

      existingContentionDetail = contention.contention_details.flatten.select{|cd| cd.active == true}

      clarificationInfo = clarificationRequest.clarificationText

      contentionDetail = ContentionDetail.create(contention_id: existingContentionDetail[0].contention_id,
                                                 description: existingContentionDetail[0].description,
                                                 active: true,
                                                 event_id: contention.identifier)

      existingContentionDetail[0].active = false
      existingContentionDetail[0].save

      contentionDetail.save

      clarificationTypeRequest = ClarificationType.find_by_code("REQUEST")
      clarificationDetail = ClarificationDetail.create(contention_id: contention.id,
                                                       event_id: contention.exam_related_contention_id,
                                                       text: clarificationInfo[contention.exam_related_contention_id],
                                                       clarification_type: clarificationTypeRequest.id,
                                                       clarified: false)
      clarificationDetail.save
    end
  end

  def view_contention
    @contention = Contention.find_by_identifier(params[:id])
    if @contention.nil?
      redirect_to dashboards_path, :alert => "Unable to find the contention"
    end

    #build clarification_details by eventId
    @event_ids = @contention.clarification_details.select(:event_id).map(&:event_id).uniq
    @clarificationByEventId = Hash.new
    if (@event_ids != nil && @event_ids.count > 0)
      @event_ids.each do |eventId|
        @clarificationByEventId[eventId] = ClarificationDetail.where(:event_id => eventId, :contention_id => @contention.id).order("created_at ASC")
      end
    end
  end

  def redirectToHandleGetClarification(examRequestIdentifier, contentionIds)
    session[:id] = examRequestIdentifier
    session[:c_ids] = contentionIds
    redirect_to action: "handleGetClarification"
  end

  def handleGetClarification
    @exam_request = ExamRequest.find_by_identifier(session[:id])
    selected_contention_ids = session[:c_ids]
    @contentions = Contention.find(selected_contention_ids)

    session[:id] = ""
    session[:c_ids] = ""

    if (session[:cr] == "" || session[:cr].nil?)
      @cr = ClarificationRequest.new
      @cr.clarificationText = Hash.new
      selected_contention_ids.each do |contentionId|
        contention = Contention.find_by_id(contentionId)
        @cr.clarificationText[contention.exam_related_contention_id] = ""
      end
    else
      @cr = session[:cr]
      session[:cr] = ""
    end

    render :clarification_info
  end

  def accept_clarification
    ExamRequest.find(@exam_request).update_attribute(:exam_request_state_id, 2)
    note = "#{current_user.name} accepted clarification from VBMS"
    exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id,
                                                  event: "Clarification Text",
                                                  notes: note)
    exam_request_history.save
    flash[:notice] = 'Exam Request is updated with the clarification response received from VBMS.'
    redirect_to view_exam_request_path(@exam_request.identifier)
  end

  def receive_clarification
  end

  def select_contentions_submit
    @claim = Claim.find_by_id(@exam_request.claim_id)
    selected_contention_ids = params[:c_ids]

    if selected_contention_ids.present?
      if (params[:p] == 'GetClarification')
        redirectToHandleGetClarification(params[:er_id], params[:c_ids])
      else
        @selected_contentions = Contention.where(id: selected_contention_ids)
                                          .includes(:contention_details)
        render :create_exams
      end
    else
      @contentions = @claim.contentions.where(:is_contention_cancelled => nil)
                                       .includes(:contention_details)
      flash[:alert] = "Please select at least one contention.";
      if params[:p] == 'GetClarification'
        redirect_to action: "get_clarification", er_id: params[:er_id]
      else
        render :select_contentions
      end
    end
  end

  def change_site
    prepareExamRequestData(@exam_request)
    @sites = Site.all
  end

  def create
   ActiveRecord::Base.transaction do
    flash.clear
    if !params[:new_exam_request].present?
      @exam_request = ExamRequest.find_by_identifier(params[:er_id])
      prepareExamRequestData(@exam_request)

      @sites = Site.order_asc
      @claim = Claim.find_by_id(@exam_request.claim_id)
      @contentions = nil
      if @claim.present? && @claim.contentions.present?
        @contentions = @claim.contentions.includes(:contention_details)
      end
    end
    if params[:exam_request_secondary_action] && params[:secondary_action] == 'assign_to_different_site'
      render :change_site
    elsif params[:create_exams]
      # Check to see if there are multiple contentions. If yes, display the page to select a contention
      @claim = Claim.find_by_id(@exam_request.claim_id)
      @contentions = @claim.contentions.where(:is_contention_cancelled => nil)
                                       .includes(:contention_details)

      if @contentions.present?
        @select_contention_caption = "You have opted to create an examination. Please select one or more contentions from the below entries"
        render :select_contentions
      else
        flash[:alert] = "Examination cannot be created as there are no active contentions.";
        redirect_to :back
      end
    elsif params[:select_contentions_submit]
     redirect_to action: "select_contentions_submit", er_id: params[:er_id], c_ids: params[:contention_ids], p: params[:p]
    elsif params[:create_exams_submit]
      #create an examination using the contention and site from the ExamRequest
      @claim = @exam_request.claim
      curr_site = @exam_request.site

      @examinationState = ExaminationState.find_by_code "PENDING"

      selected_contention_ids = params[:contention_ids]
      if selected_contention_ids.present?
        @examination = Examination.new(title: "Examination created ", claim: @claim, site: curr_site, examination_state: @examinationState, exam_request: @exam_request, purpose: params["purpose"], examination_state_start_date: DateTime.current)

        @examination.set_the_creating_user(current_user.id) # passing it along to the evaluation as assigner
        @examination.identifier = SecureRandom.uuid
        selected_contention_ids.each_with_index do |contention_id, index|
          contention = Contention.find_by_id(contention_id)
          @examination.contentions << contention
        end

        @examination.examination_review_questionnaire = ExaminationReviewQuestionnaire.create(:claim_folder_reviewed => false)
        @examination.save

        examinationSchedule = ExaminationSchedule.create(examination: @examination, active: true)
        examinationSchedule.save

        @examination.examination_schedules << examinationSchedule

        addExamHistory(selected_contention_ids, @exam_request)
        addExaminationHistory(selected_contention_ids, @examination)
      end

      flash[:notice] = "Examination has been successfully created."
      site_triage_users = User.all.includes(:sites).where(:sites => {name: curr_site.name}).includes(:site_role_sets).where(:site_role_sets => {triage: "true"})

      site_triage_users.try(:each){|st|
       # ExamManagementMailer.examination_created(st).deliver_now
      }
      redirect_to dashboards_path

    elsif params[:change_site_submit]
      # Check to see if a new site was picked.
      if @exam_request.site_id.to_s != params[:site_id]
        new_site = Site.find_by_id(params[:site_id])
        prev_site = Site.find_by_id(@exam_request.site_id)
        notes = "#{current_user.name} changed the site from #{prev_site.name} to #{new_site.name}."

        @exam_request.site_id = params[:site_id]
        @exam_request.save

        exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes, event: "Change Site")
        exam_request_history.save

        flash[:notice] = "Exam Request has been successfully assigned to #{new_site.name}."
        site_triage_users = User.all.includes(:sites).where(:sites => {name: new_site.name}).includes(:site_role_sets).where(:site_role_sets => {triage: "true"})
        site_triage_users.try(:each){|st|
          # ExamManagementMailer.exam_request_site_changed(st).deliver_now
        }
      end
      @exam_request_history = Array(ExamRequestHistory.where(exam_request_id: @exam_request.id).order(created_at: :DESC))
      render :view_exam_request

    elsif params[:new_exam_request]
      @claim = Claim.new()
      @claim.file_number = params[:file_number]
      @claim.first_name = params[:first_name]
      @claim.middle_name = params[:middle_name]
      @claim.last_name = params[:last_name]
      @claim.date_of_birth = @claim.build_date_of_birth(params)
      @claim.facility_name = params[:facility_name]
      @claim.save

      @exam_request = ExamRequest.new()
      @exam_request.claim_id = @claim.id
      @exam_request.site_id = params[:site_id]
      @exam_request.identifier = SecureRandom.uuid
      @exam_request.request_date = @exam_request.build_request_date(params)
      @exam_request.exam_request_state = ExamRequestState.find_by_id(1)

      notes = "Scheduled Exam Request has been initiated by " + current_user.first_name + " " + current_user.last_name + "."
      @exam_request_history = ExamRequestHistory.new(exam_request_id: @exam_request.id, notes: notes)

      if @claim.save && @exam_request.save && @exam_request_history.save
        flash[:notice] = "Scheduled Exam Request has been successfully created."
        if params[:contention_name].present?
          @contention = Contention.create(
            name: params[:contention_name],
            claim_id: @claim.id,
            identifier: SecureRandom.uuid,
            exam_id: @exam_request.id)

          @contention_details = ContentionDetail.create(
            contention_id: @contention.id,
            description: params[:contention_description],
            active: true,
            name: params[:contention_name])
        end

        triage_users = User.get_triage_users_by_site(params[:site_id])
        if triage_users.present?
          triage_users.each do |key, value|
            puts "Sending email to ::: " + key["email"]
            @user = User.find_by_id(key["id"])
            @user.email = "cui.testing@gmail.com"
            #cs UserMailer.send_create_exam_request_email(@user).deliver_now
          end
        end
        redirect_to new_exam_request_path
      else
        @claim = Claim.new
        @contentions = @claim.contentions + [Contention.new]
        @all_sites = Site.all
        if @all_sites.present?
          @sites = @all_sites.map{ |s| [s.name, s.id] }
        end
        flash.now[:alert] = "Please enter values for all required fields."
        render action: :new
      end
    elsif
      redirect_to dashboards_path
    end
   end
  end

  def create_exams

  end

  private

  def get_exam_request
    @exam_request = ExamRequest.find_by_identifier(params[:id])
  end

  def get_exam_request_using_er_id
    @exam_request = ExamRequest.find_by_identifier(params[:er_id])
  end

  def redirect_if_no_exam_request
    if @exam_request.nil?
      flash[:alert] = "Unable to locate the Exam Request record."
      redirect_to dashboards_path
    end
  end

  def addExamHistory(selectedContentionIds, examRequest)
    notes = current_user.first_name + " " + current_user.last_name + " created an examination for the following contention(s): "
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      name = contention.contention_details[0].description.present? ? contention.contention_details[0].description : "na"
      notes = notes + separator + name
    end
    @exam_request_history = ExamRequestHistory.new(exam_request_id: examRequest.id, notes: notes)
    @exam_request_history.save
  end

  def addExaminationHistory(selectedContentionIds, examination)
    notes = current_user.first_name + " " + current_user.last_name + " created the examination for"
    selectedContentionIds.each_with_index do |contention_id, index|
      contention = Contention.find_by_id(contention_id)
      separator = ""
      if index > 0 && index == selectedContentionIds.length-1
        separator = " and "
      elsif index > 0
        separator = ", "
      else
        separator = " "
      end
      contention.contention_details[0].name.present? ? name = contention.contention_details[0].name : name = "na"
      notes = notes + separator + name
    end
    @examination_history = ExaminationHistory.new(examination_id: examination.id, notes: notes)
    @examination_history.save
  end
end
