class DiagnosisModifiersController < ApplicationController
  include DataTablePaginator
  before_action :set_diagnosis_modifier, only: [:show, :edit, :update, :destroy]

  # GET /diagnosis_modifiers
  # GET /diagnosis_modifiers.json
  def index
  end

  # GET /diagnosis_modifiers/1
  # GET /diagnosis_modifiers/1.json
  def show
    @diagnosis_modifier = DiagnosisModifier.find(params[:id])
    if params[:delete_diagnosis_id].present?
      d = @diagnosis_modifier.diagnoses.find_by_id(params[:delete_diagnosis_id])
      @diagnosis_modifier.diagnoses.delete(d)
      flash.now[:notice] = "Diagnosis successfully removed."
    end
  end

  # GET /diagnosis_modifiers/new
  def new
    @diagnosis_modifier = DiagnosisModifier.new
    @diagnoses_not_yet_added = Diagnosis.all
    params[:diagnosis_id].present? ? @diagnosis = Diagnosis.find(params[:diagnosis_id]) : false
  end

  # GET /diagnosis_modifiers/1/edit
  def edit
    @identifier = "TEMP_IDENTIFIER_VALUE"
    if params[:delete_diagnosis_id].present?
      d = @diagnosis_modifier.diagnoses.find_by_id(params[:delete_diagnosis_id])
      @diagnosis_modifier.diagnoses.delete(d)
      flash.now[:notice] = "Diagnosis successfully removed."
    elsif params[:delete_list_value_index].present?
      lindex = params[:delete_list_value_index].to_i
      @diagnosis_modifier.list_values.delete_at(lindex)
      @diagnosis_modifier.save
      flash.now[:notice] = "List value removed."
    end

    set_diagnoses_not_yet_added @diagnosis_modifier
    # @generated_html = @diagnosis_modifier.build_html("DIAGNOSIS_NAME", @identifier)
  end

  def generated_html
    @identifier = "TEMP_IDENTIFIER_VALUE"
    @diagnosis_modifier = DiagnosisModifier.find(params[:diagnosis_modifier_id])
    @generated_html = @diagnosis_modifier.build_html("DIAGNOSIS_NAME", @identifier)
    render partial: 'evaluation_templates/displayed_result'
  end

  # POST /diagnosis_modifiers
  # POST /diagnosis_modifiers.json
  def create
    @diagnosis_modifier = DiagnosisModifier.new(diagnosis_modifier_params)
    @diagnosis_modifier.list_values = diagnosis_modifier_params[:list_values].split("\n").map(&:strip)
    respond_to do |format|
      if @diagnosis_modifier.save
        format.html {
          if params[:diagnosis_id].present?
            @diagnosis = Diagnosis.find(params[:diagnosis_id])
            @diagnosis.diagnosis_modifiers << @diagnosis_modifier
          end
          if params[:diagnosis_modifier][:prev_url]
            uri = URI.parse(params[:diagnosis_modifier][:prev_url])
            redirect_to uri.to_s, notice: 'Diagnosis modifier was successfully created.'
          else
            redirect_to @diagnosis_modifier, notice: 'Diagnosis modifier was successfully created.'
          end
        }
        format.json { render action: 'show', status: :created, location: @diagnosis_modifier }
      else
        format.html { render action: 'new' }
        format.json { render json: @diagnosis_modifier.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /diagnosis_modifiers/1
  # PATCH/PUT /diagnosis_modifiers/1.json
  def update
    if params[:identifier].present?
      redirect_to edit_diagnosis_modifier_path(@diagnosis_modifier, :identifier => params[:identifier])
    else
      respond_to do |format|
        orig_dm_name = @diagnosis_modifier.name
        list_values = @diagnosis_modifier.list_values.clone
        if @diagnosis_modifier.update(diagnosis_modifier_params)
          if diagnosis_modifier_params[:list_values]
            diagnosis_modifier_params[:list_values].split("\n").map(&:strip).each do |v|
              list_values << v
            end
          end
          if params[:diagnosis_modifier] && params[:diagnosis_modifier][:diagnosis_ids]
            params[:diagnosis_modifier][:diagnosis_ids].each do |d|
              diagnosis = Diagnosis.find_by_id(d)
              if diagnosis
                @diagnosis_modifier.diagnoses << diagnosis
              end
            end
          end
          @diagnosis_modifier.list_values = list_values
          @diagnosis_modifier.save
          @diagnosis_modifier.update_dma_names if orig_dm_name != @diagnosis_modifier.name
          format.html { redirect_to edit_diagnosis_modifier_path(@diagnosis_modifier), notice: 'Diagnosis modifier was successfully updated.' }
          format.json { head :no_content }
        else
          format.html {
            @diagnoses_not_yet_added = Diagnosis.all
            render action: 'edit'
          }
          format.json { render json: @diagnosis_modifier.errors, status: :unprocessable_entity }
        end
      end
    end
  end

  # DELETE /diagnosis_modifiers/1
  # DELETE /diagnosis_modifiers/1.json
  def destroy
    @diagnosis_modifier.destroy
    respond_to do |format|
      format.html { redirect_to diagnosis_modifiers_url }
      format.json { head :no_content }
    end
  end

  def paged_list

    diagnosis_modifiers_to_fields_func = -> (dm) do
      {
        id:                 dm.id,
        name:               dm.name.try(:humanize),
        row_label:          dm.label.try(:humanize),
        mod_type:           dm.mod_type.try(:humanize),
        list_values:        dm.list_values,
        edit:               edit_diagnosis_modifier_path(dm),
        destroy:            diagnosis_modifier_path(dm)
      }
    end
    ordered_diagnosis_modifiers =  apply_ordering_to_query(DiagnosisModifier.filter(params), DiagnosisModifier::FIELDS_FOR_RESULTSET, params['order'])
    return_data = datatables_json_for_query_using_func(
      ordered_diagnosis_modifiers, diagnosis_modifiers_to_fields_func
    )
    puts "return data: "
    puts return_data.inspect
    render json: return_data
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_diagnosis_modifier
      @diagnosis_modifier = DiagnosisModifier.find(params[:id])
    end

    def set_diagnoses_not_yet_added diagnosis_modifier
      @diagnoses_not_yet_added = Diagnosis.all.order("name ASC")
      diagnosis_modifier.diagnoses.each do |da|
        @diagnoses_not_yet_added = @diagnoses_not_yet_added.reject{|d| d == da}
      end
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def diagnosis_modifier_params
      params.require(:diagnosis_modifier).permit(:name, :mod_type, :list_values)
    end
end
