class DbqFormsController < ApplicationController
  before_action :set_dbq_form, only: [:show, :edit, :show_form, :edit_form, :update, :destroy]

  # GET /dbq_forms
  # GET /dbq_forms.json
  def index
    @dbq_forms = DbqForm.all_templates.order(id: :asc)
  end

  # GET /dbq_forms/1
  # GET /dbq_forms/1.json
  def show
  end

  # GET /dbq_forms/new
  def new
    @dbq_form = DbqForm.new
    @dbq_sections = @dbq_form.dbq_sections.build
    @dbq_elements = @dbq_sections.dbq_elements.build
  end

  # GET /dbq_forms/1/edit
  def edit
  end

  # GET /dbq_forms/1
  # GET /dbq_forms/1.json
  def show_form
  end

  # GET /dbq_forms/1/edit_form
  def edit_form
  end

  # POST /dbq_forms
  # POST /dbq_forms.json
  def create
    @dbq_form = DbqForm.new(dbq_form_params)
    respond_to do |format|
      if @dbq_form.save
        format.html { redirect_to edit_dbq_form_path @dbq_form, notice: 'Dbq form was successfully created.' }
        format.json { render action: 'show', status: :created, location: @dbq_form }
      else
        format.html { render action: 'new' }
        format.json { render json: @dbq_form.errors, status: :unprocessable_entity }
      end
    end
  end

  # PATCH/PUT /dbq_forms/1
  # PATCH/PUT /dbq_forms/1.json
  def update
#    params.try(:[], "_dbq_form") == "true" ? remove_all_sections : false
    respond_to do |format|
      if @dbq_form.update(dbq_form_params)
        format.html {
          if params[:show_dbq].present?
            flash[:notice] = 'DBQ successfully saved.'
            redirect_to show_form_dbq_form_path @dbq_form
          else
            flash[:notice] = 'Dbq form was successfully updated.'
            if params.try(:[], "_dbq_form") == "true"
              redirect_to edit_form_dbq_form_path @dbq_form
            else
              redirect_to edit_dbq_form_path @dbq_form
            end
          end
        }
        format.json { head :no_content }
        format.js { }
      else
        format.html { render action: 'edit' }
        format.json { render json: @dbq_form.errors, status: :unprocessable_entity }
        format.js { }
      end
    end
  end

  # DELETE /dbq_forms/1
  # DELETE /dbq_forms/1.json
  def destroy
    @dbq_form.destroy
    respond_to do |format|
      format.html { redirect_to dbq_forms_url }
      format.json { head :no_content }
    end
  end

  # GET /pdf/1
  def to_pdf
    @dbq_form = DbqForm.find(params[:id])
    respond_to do |format|
      format.pdf do
        render :pdf => "my_pdf_name.pdf",
          :template => "dbq_forms/pdf.html.haml",
          :layout => "dbq_pdf"
      end
    end
  end

  def save_to_system
    @dbq_form = DbqForm.find(params[:id])
    html = render_to_string(:template => "dbq_forms/pdf.html.haml", :layout => "dbq_pdf")
    pdf = WickedPdf.new.pdf_from_string(html)
    filename = create_dbqform_filename(@dbq_form) + ".pdf"

    save_path = Rails.root.join('files', 'dbq_pdfs', filename)
    File.open(save_path, 'wb') do |file|
      file << pdf
    end

    redirect_to show_form_dbq_form_path @dbq_form
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_dbq_form
      @dbq_form = DbqForm.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def dbq_form_params
      params.require(:dbq_form).permit(
        :id,      :name,    :title,     :series_id,
        :version, :status,  :archived,  :template,
        dbq_sections_attributes: [
          :id, :_destroy, :title, :section_type,
          dbq_elements_attributes: [
            :id,    :_destroy, :order_num, :element_type,
            :label, :value,
            value: [],
            possible_values: []
          ]
        ]
      )
    end

    # Used to prevent duplicate sections from getting saved to the DBQ Form.
    def remove_all_sections
      @dbq_form.dbq_sections.each do |s|
        s.destroy!
      end
    end

    def create_dbqform_filename dbq_form
      exam = dbq_form.examination
      filename   = exam.file_number + "_"
      filename  += exam.most_recent_active_appointment.exam_date_time.strftime('%Y%m%d') + "_"
      filename  += dbq_form.title.parameterize('_')
    end
end
