module Cpp::Api::V1

  class VeteransController < ActionController::Base
    protect_from_forgery :with => :exception

    def search
      begin
        if VIA_ACTIVE_FOR_CPP
          render json: {data: VETERAN.filtered_veterans(search_params, session[:vista])}
        else
          render json: {data: VETERAN.filtered_veterans(search_params)}
        end
      rescue VIA_API::ViaApiError => e
        render json: {error: "VIA API Error: #{e}"}
      end
    end

    def get_veteran_by_ssn
      begin
        if VIA_ACTIVE_FOR_CPP
          render json: {data: VETERAN.find_by_ssn(params[:ssn], session[:vista])}
        else
          render json: {data: VETERAN.find_by_ssn(params[:ssn])}
        end
      rescue VIA_API::ViaApiError => e
        render json: {error: "VIA API Error: #{e}"}
      end
    end

  private

    def search_params
      params.permit(:from_date, :to_date, :ssn, :first_name, :last_name)
    end

  end

end
