class ContentionsController < ApplicationController
  include ContentionHelper
  before_filter :assign_claim, except: [:get_associated_dbq_array, :get_not_associated_dbq_array]
  before_filter :assign_contention, except: [:new, :create, :get_associated_dbq_array, :get_not_associated_dbq_array]
  skip_before_action :clear_current_site
  check_authorization
  authorize_resource

  def new
    @contention = @claim.contentions.new
  end

  def create
    @contention = @claim.contentions.new(contention_params)
    @contention.assigner = current_user
    if @contention.save
      flash[:notice] = "Contention created."
      redirect_to @claim
    else
      flash[:alert] = @contention.errors.full_messages.join(" ")
      render :new
    end
  end

  def show
    @claims_other_contentions =  @claim.other_contentions(@contention)
  end

  def update
    respond_to do |format|
      contention_updated = @contention.update_attributes(contention_params)
      format.html do
        if contention_updated
          flash[:notice] = "Contention updated."
          redirect_to [@claim, @contention]
        else
          flash[:alert] = @contention.errors
          render :show
        end
      end
      format.js do
        @claims_other_contentions = @claim.other_contentions(@contention)
      end
    end
  end

  def resolve
    if @contention.resolve!(current_user)
      unless current_user.is_under_review
        @contention.review!(current_user)
        @contention.send_evaluations
      end
      flash[:notice] = "Contention has been resolved and sent to administrator for review."
      redirect_to @claim
    else
      @claims_other_contentions =  @claim.other_contentions(@contention)
      alert_messages = []
      if @contention.history.blank?
        alert_messages << "Contention history cannot be blank."
      end
      if @contention.claim_folder_reviewed.nil?
        alert_messages << "A contention claim folder reviewed option must be picked."
      end
      if !@contention.claim_folder_reviewed && !@contention.one_or_more_reviewed_checkboxes_selected?
        alert_messages << "At least one document must be reviewed if the Veteran's VA folder has not been reviewed"
      end
      flash[:alert] = alert_messages.join(" ")
      render :show
    end
  end

  def accept
    unless @contention.reviewed?
      @contention.review!(current_user)
      @contention.send_evaluations
    end
    flash[:notice] = "Contention has been accepted."
    redirect_to claims_path
  end

  def get_associated_dbq_array

    dbq_array = generate_associated_dbq_array(params[:contention_id].to_i)
    render json: dbq_array
  end

  def get_not_associated_dbq_array

    dbq_array = generate_not_associated_dbq_array(params[:contention_id].to_i)
    render json: dbq_array
  end

  private

  def assign_contention
    @contention = @claim.contentions.find(params[:id])
  end

  def contention_params
    params.require(:contention).permit(
      :name,
      :history,
      :claim_folder_reviewed,
      :no_diagnosis,
      :reviewed_military_service_treatment_records,
      :reviewed_military_service_personnel_records,
      :reviewed_military_enlistment_examination,
      :reviewed_military_separation_examination,
      :reviewed_military_post_deployment_questionnaire,
      :reviewed_dod_form_214_separation_documents,
      :reviewed_vha_treatment_records,
      :reviewed_civilian_medical_records,
      :reviewed_interviews_with_collateral_witnesses,
      :reviewed_not_indicated,
      evaluation_ids: [],
    )
  end
end
