class AssignClinicianController < ApplicationController
  check_authorization
  authorize_resource class: false

  def new
    @examination = Examination.find_by_identifier(params[:examination_processor_id])

    if (@examination.examination_state.code == "CANCELLED" && !@examination.acknowledged)
      redirect_to :controller => 'examination_processors', :action => 'ack', :id => @examination.identifier
    end

    @data = {}
    User.get_clinicians_by_site(@examination.site_id).each do |clinician|
      @data[clinician.name] = clinician.id
    end
  end

  def update
    examination = Examination.find_by_identifier(params[:examination][:examination_identifier])
    clinician = User.find_by_id(params[:clinician_id])

    flash[:notice] = ExaminationAssignClinician.new.run!(examination, clinician, current_user)
    redirect_to :controller => 'examination_processors', :action => 'view_examination', :identifier => examination.identifier
  end

end
