
class ApplicationController < ActionController::Base
  before_action :set_paper_trail_whodunnit

  include ActionView::Helpers::SanitizeHelper
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  # skip_before_action: verify_authenticity_token, only: saml
  protect_from_forgery with: :exception  #DOM-133, this must be on to mitigate CSRF via WASA finding
  before_filter :authenticate_user_and_handle_cookies, :except => [:cui_ssoi, :cui_callback]
  before_action :configure_permitted_parameters, if: :devise_controller?
  before_action :clear_current_site
  skip_before_action :clear_current_site, only: [:pingserver]
  before_action :jump_to
  before_action :protect_from_host_header_attack
  before_action :sanitize_params, only: [:create, :update]
  before_filter :set_cache_headers

  def protect_from_host_header_attack
    env['HTTP_HOST'] = default_url_options.fetch(:host, env['HTTP_HOST'])
  end

  # handle two before_filter methods in sequence:
  # 1. authenticate user using devise
  # 2. after authentication, if successful: perform timezone check and
  # set timezone if preferences value does not match.
  def authenticate_user_and_handle_cookies
    authenticate_user!
    if current_user.present?
      current_user.create_preferences_if_empty
      # set timezone in preferences to match user session cookie
      timezone_from_browser = cookies['browser.timezone']
      if timezone_from_browser.present? && current_user.present?
        if timezone_from_browser != current_user.user_preference.time_zone
          current_user.user_preference.time_zone = timezone_from_browser
          current_user.user_preference.save!
        end
      end
    end
  end

  rescue_from CanCan::AccessDenied do |exception|
    Rails.logger.debug "Access denied on #{exception.action} #{exception.subject.inspect}"

    if current_user.is_cpp_user?
      redirect_to referrals_url, alert: exception.message
    else
      redirect_to root_path, alert: exception.message
    end
  end

  # rescue_from ActiveRecord::RecordNotFound do |exception|
  #   redirect_to root_path, alert: "Record not found, or you do not have access to that record."
  # end

  def pingserver
    return true;
    #nothing
  end

  def ssoi_method
  end

  def ssoe_method
  end

  def login
    login_method = case true
      when current_user.is_cpp_user?
        JUMP_TO_CONFIG[current_user.is_non_vha? ? 'non_vha' : 'vha_cc'].select{|x| x["URL"] == params[:jump_to_select]}.first["login"]
      when current_user.is_cui_user?
        JUMP_TO_CONFIG['cui_user'].select{|x| x["URL"] == params[:jump_to_select]}.first["login"]
      end
    params[:jump_to_select] = root_url.to_s + params[:jump_to_select] if current_user.is_cui_user?
    if params[:jump_to_select] =~ URI::regexp
      begin
        response = Faraday.get params[:jump_to_select]
        case login_method
          when 'none'
            uri = URI.parse(params[:jump_to_select])
            redirect_to uri.to_s
          when 'ssoi'
            redirect_to :back, alert: "SSOI capability is under development"
            #ssoi_method
          when 'ssoe'
            redirect_to :back, alert: "SSOE capability is under development"
            #ssoe_method
        else
          #login error
        end
      rescue
        redirect_to :back, alert: "Website is not responding. Please try again later"
      end
    else
      redirect_to :back, alert: "Please try again later"
    end
  end


  # Overwriting the sign_out redirect path method to allow for different redirect paths
  # for CPP and non-CPP users based on cookie value assigned in
  # SessionsController#save_cpp_status.  Cookie gets deleted in this method, before redirect.
  def after_sign_out_path_for(resource_or_scope)
    is_cpp = cookies['is_cpp_user']
    cookies.delete('is_cpp_user')
    if is_cpp
      cpp_path
    else
      root_path
    end
  end

  # Get list of facilities corresponding to VISN id passed in.
  # SMELL: This method is specific to the VISN resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_facilities
    visn = Visn.find(params[:id])
    @facilities = visn.facilities
    respond_to do |format|
      format.json { render json: @facilities}
    end
  end

  # Get list of providers corresponding to facility id passed in.
  # SMELL: This method is specific to the Facility resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_providers
    facilities = Facility.find(params[:id])
    @providers = facilities.providers
    respond_to do |format|
      format.json { render json: @providers}
    end
  end

  # Get list of providers corresponding to VISN id passed in.
  # SMELL: This method is specific to the VISN resource (currently not a resource)
  # and should not be applied to all controllers.
  def get_providers_without_facility
    @providers = Provider.includes(:facility).where('facilities.visn_id = ?', params[:id]).references(:facilities)
    respond_to do |format|
      format.json { render json: @providers}
    end
  end

  def home
    if current_user.is_cpp_user?
      if VIA_ACTIVE_FOR_CPP && current_user.is_vha? && session[:vista].blank?
        redirect_to vista_path
      elsif current_user.is_vha?
        redirect_to consultations_path
      elsif current_user.is_non_vha?
        redirect_to referrals_path
      end
    else
      redirect_to '/landing/index'
    end
  end

  protected

  # remove <script> and <href> tags from input fields
  # DOM-281/DOM-355 (WASA 3rd report)
  def sanitize(value)
    v = ActionController::Base.helpers.strip_links(value)
    ActionController::Base.helpers.sanitize(v)
  end

  def sanitize_array(a)
    a.map! do |e|
      if e.is_a?(String) || e.is_a?(Integer)
        sanitize(e)
      elsif e.is_a?(Array)
        sanitize_array(e)
      elsif e.is_a?(Hash)
        sanitize_hash(e)
      else
        e
      end
    end
    a
  end

  def sanitize_hash(h)
    h.each do |key, value|
      if value.is_a?(Hash)
        h[key] = sanitize_hash(value)
      elsif value.is_a?(String) || value.is_a?(Integer)
        h[key] = sanitize(value)
      elsif value.is_a?(Array)
        h[key] = sanitize_array(value)
      end
    end
    h
  end

  def sanitize_params
    sanitize_hash(params)
  end

  def configure_permitted_parameters
    devise_parameter_sanitizer.permit(:sign_up, keys: [:first_name, :last_name])
  end

  private

  def jump_to
    if current_user
      # SMELL: perfomance impact.  See http://midwire.github.io/blog/2011/08/26/ruby-performance-case-vs-if-elsif/
      @options_jump_to = case true
      when current_user.is_cpp_user?
        JUMP_TO_CONFIG[current_user.is_non_vha? ? 'non_vha' : 'vha_cc'].collect{|x| [x["title"],x["URL"]]}
      when current_user.is_cui_user?
        JUMP_TO_CONFIG['cui_user'].collect{|x| [x["title"],x["URL"]]}
      end
    end
  end

  def assign_claim
    @claim = Claim.find(params[:claim_id])
  end

  def clear_current_site
    $current_site = nil
    $current_site_roles = nil
  end

  def set_cache_headers
    response.headers["Cache-Control"] = "no-cache, no-store"
    response.headers["Pragma"] = "no-cache"
    response.headers["Expires"] = "Fri, 01 Jan 1990 00:00:00 GMT"
  end

end
