# This error is raised when incoming message does not validate with Exam Management 1.0 xsd
class ExamManagementValidationError < RuntimeError; end

class Api::V1::ClaimsController < ActionController::Base
  protect_from_forgery with: :exception
  skip_before_filter :verify_authenticity_token
  include ExamRequestHelper, ContentionHelper, AppointmentHelper, ClarificationHelper

  def create
    exam_request_xml = request.body.read
    begin

      notification_doc  = Nokogiri::XML(exam_request_xml)
      notification_type = XmlHelper.get_content_type(notification_doc)
      validate_xml(notification_doc, notification_type)

      exam_request_hash = Hash.from_xml(exam_request_xml)

      if notification_type == 'ExamSchedulingRequestCreatedEvent'
        processExamSchedulingRequestCreatedEvent(exam_request_xml, exam_request_hash)
        #ExamRequestHelper.delay.createRequestObject(exam_request_xml)
        render :json => "Request to process ExamManagementEventNotification received", status: 200
      elsif notification_type == 'ContentionCancellationRequestedEvent'
        processCancellationRequest(notification_doc)
        render :json => "Request to process ContentionCancellationRequestedEvent received", status: 200
      elsif notification_type == 'AppointmentCancelRequestEvent'
        processAppointmentCancelRequestEvent(notification_doc)
        render :json => "AppointmentCancelRequestEvent successfully received"
      elsif notification_type == 'ExamSchedulingRequestCancellationEvent'
        processExamSchedulingRequestCancellationEvent(notification_doc)
        render :json => "ExamSchedulingRequestCancellationEvent successfully received"
      elsif notification_type == 'RescheduleRequestEvent'
        processRescheduleRequestEvent(notification_doc)
        render :json => "RescheduleRequestEvent successfully received"
      elsif notification_type == 'ClarificationResponseEvent'
        process_clarification_response_event(notification_doc)
        render :json => "ClarificationResponseEvent successfully received"
      elsif notification_type == 'NarrativeClarificationResponseEvent'
        process_narrative_clarification_response_event(notification_doc)
        render :json => "NarrativeClarificationResponseEvent successfully received"
      elsif notification_type == 'ReworkExamSchedulingRequestCreatedEvent'
        process_reworked_exam_scheduling_request_created_event(exam_request_xml, exam_request_hash)
        render :json => "ReworkExamSchedulingRequestCreatedEvent successfully received"
      else
        render :json => "Invalid request"
      end
    rescue ExamManagementValidationError, StandardError => e
      render :json => "\nInvalid request:\n" + e.message+"\n"+e.backtrace.join("\n"), status: 400
      Rails.logger.info e.message
    end
  end

  private

  def validate_xml orig_doc, msg_type
    xsd_path = Rails.root.join("app", "xsd", "ExamManagement", "exchange", "ExamManagement-2.0.xsd")
    xsd = Nokogiri::XML::Schema(File.open(xsd_path))
    doc = process_atom_feed orig_doc

    errors = xsd.validate(doc).map { |error| error.message }
    if !errors.empty?
      error_str = errors.join("\n")
      raise ExamManagementValidationError.new("Incoming message, "+msg_type+", is not compatible with Exam Management 2.0 IEPD\n"\
                                              "#{errors.length} validation error(s):\n"\
                                              "#{error_str}")
    end
  end

  def process_atom_feed orig_doc
    em_tag = orig_doc.xpath("//em:ExamManagementEventNotification", "em" => "http://va.gov/vler/schemas/vlerSupersetSchema/examManagement/2.0")
    doc = Nokogiri::XML("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")

    raise ExamManagementValidationError.new("Message "+msg_type+", might not be an IEPD 2.0") if doc.nil?

    doc.root = em_tag.first
    doc
  end

  def performInitialCheck(notification_xml)
    notificationXml = ExamManagementNotification.find_by_xml(notification_xml)
    if (notificationXml != nil)
      raise Exception, "Duplicate ExamManagement notification."
      return false
    elsif
      #save the notification
      ExamManagementNotification.create(xml: notification_xml)
      return true
    end
    return false
  end


end
