//= require dataTables/jquery.dataTables

$(document).ready(function() {

  function childReferralTableColumns() {
    var columnsArr = [];
    return columnsArr = [
        {name: 'referral_type', data: 'referral_type', sortable: true},
        {name: 'authorization_number', data: 'authorization_number', sortable: true},
        {name: 'coordinator_name', data: 'coordinator_name', sortable: true},
        {name: 'provider_name', data: 'provider_name', sortable: true},
        {name: 'date', data: 'date', sortable: true},
        {name: 'referral_status', data: 'referral_status',  sortable: true},
        {name: 'links', sortable: false, defaultContent: "<button class='edit text-button add-referral-edit'>Edit</button>"}
    ];
  }

  var $childReferralTable = $('#vhaUserConsData');
  $childReferralTable.DataTable({
        bLengthChange: false,
        aaSorting: [4, 'asc'],
        bSort: true,
        bFilter: false,
        columns: childReferralTableColumns(),
        "pageLength": 5,
        "columns": [
            { "width": "32%" },
            { "width": "10%" },
            { "width": "28%" },
            { "width": "25%" },
            { "width": "1%" },
            { "width": "25%" },
            { "width": "10%" },
        ]
    });

  $childReferralTable.creatableDataTable("#new_referral.creatable-target");

  $('table#vhaUserConsData.data-table.inline-editable').each(function () {
      $(this).inlineEditable({
          savePutURL: inlineEditSaveUrl
      });
  });

  function inlineEditSaveUrl(saveButton) {
      var referralId = $(saveButton).data("referral-id");
      return "/referrals/" + referralId + ".json";
  }

  $('.from_date').datepicker({ dateFormat: 'mm/dd/yy' });
  $('.to_date').datepicker({ dateFormat: 'mm/dd/yy' });

});
