(function($) {

    $.fn.inlineEditable = function(options) {
        var settings = $.extend({
            saveSuccessCallback: null,
            saveErrorCallback: null,
            savePutURL: null,
            cancelCallback: null
        }, options);

        if (!settings.savePutURL) {
            console.log(settings);
            throw "Must specify URL for the PUT in order to save edited elements.";
        }

        var props = {
            editing: null
        };

        var oTable = this.DataTable().on('click', 'button.edit', function(e) {
            e.preventDefault();

            /* Get the row as a parent of the link that was clicked on */

            var row = $(this).parents('tr')[0];
            var nRow = oTable.row(row);

            if (props.editing !== null && props.editing != nRow) {
                /* A different row is being edited - the edit should be cancelled and this row edited */
                restoreRow(oTable, props);
                editRow(oTable, nRow);
                props.editing = nRow;
            } else {
                /* No row currently being edited */
                editRow(oTable, row);
                props.editing = nRow;
            }
        });

        this.DataTable().on('click', 'button.cancel', function(e) {
            var row = $(this).parents('tr')[0];
            restoreRow(row, props);
            if (settings.cancelCallback) {
                cancelCallback;
            }
        });

        this.DataTable().on('click', 'button.save', function(e) {
            var row = $(this).parents('tr')[0];
            var successCallback = null;
            if (settings.saveSuccessCallback) {
                successCallback = settings.saveSuccessCallback;
            } else {
                successCallback = function(data) {
                    makeRowReadOnly(row, props);
                    var nRow = oTable.row(row);
                    nRow.invalidate().draw();
                };
            }
            var errorCallback = null;
            if (settings.saveErrorCallback) {
                errorCallback = settings.saveErrorCallback;
            } else {
                errorCallback = function(data) {
                    //dosomething
                }
            }
            var selectedValue = $(this).closest("tr").find($('.table_appointment_status :selected')).text();
            var originalValue = $(this).closest("tr").find($('.table_appointment_content')).text();

            if (selectedValue.match('Confirmed')){
                e.preventDefault();
                var $button = $(e.target);
                var consultation_id = parseInt($button.data('consultation-id'));
                var referral_id = parseInt($button.data('referral-id'));
                var referral_appointment_id = parseInt($button.data('referral-appointment-id'));
                var row = $button.parents('tr')[0];
                var inputs = $('td.editable input, td.editable select', row);
                var data = JSON.stringify(inputs.serializeObject());
                if (!isNaN(referral_id) && !isNaN(referral_appointment_id)) {
                    $.ajax({
                        type: "PUT",
                        url: consultation_id + "/referrals/" + referral_id + "/referral_appointments/" + referral_appointment_id + "/update_referral_appointment.json",
                        contentType: 'application/json',
                        data: data
                    })
                        .done(function (data) {
                            $button.closest('tr').find('td .table_appointment_content').html(data.appointment_status).effect("highlight", {
                                color: 'green'
                            }, 1000);
                            $('#header').after('<div class="alerts alert-box success animated fadeIn" id="saved_to_vista"><div class="row"><div class="small-12 columns">Appointment saved to Vista.</div></div></div>');
                            $('#saved_to_vista').fadeOut(10000);
                            //Toggle off the select option appointment status only if changing from previous non-confirmed status
                            if (selectedValue.match('Confirmed') && !originalValue.match('Confirmed')){
                                $button.closest('tr').find($('td.editable select')).toggle()
                            }
                            makeRowReadOnly(row, props)
                            window.scrollTo(0,0);
                        })
                        .fail(function (jqXHR) {
                            $button.prop('checked', false);
                            $button.closest('td').effect("highlight", {
                                color: 'red'
                            }, 1000);
                            $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="failed_to_save_in_vista"> <div class="row"> <div class="small-12 columns"><span>'+jqXHR.responseText+'</div> </div> </div>');
                            $('#failed_to_save_in_vista').fadeOut(10000);
                            window.scrollTo(0, 0);
                        });
                }
            } else {
                saveRow($(this), props, successCallback, errorCallback);
            }
        });

        function editRow(oTable, row) {
            var nRow = oTable.row(row);
            var aData = nRow.data();
            var jqTds = $('>td', row);
            for (var i = 0; i < jqTds.length; i++) {
                var $td = $(jqTds[i]);
                if ($td.hasClass('editable') && !($td.find("option:selected").text() == 'Confirmed')) {
                    var required = $td.hasClass('required');
                    var $input = null;
                    var custom_inputs = $td.find('.inline-editable-field');
                    if (!custom_inputs.length) {
                        $input = $('<input name=' + $td.attr('name') + ' type="text" value="' + aData[i] + '">').attr('data-original-value', aData[i]);
                        $td.html($input);
                    } else {
                        $input = $(custom_inputs[0]);
                        $input.toggle();
                        $input.siblings('span.original-value').toggle();
                    }

                    if(required){
                        $input.addClass('required');
                    }
                }
                if ($td.hasClass('links')) {
                    $td.find('button.edit, button.save, button.cancel').toggle();
                }
            }
        }

        function restoreRow(row, props) {
            var jqInputs = $('td.editable input, td.editable select', row);
            for (var i = 0; i < jqInputs.length; i++) {
                var $input = $(jqInputs[i]);
                if ($input.hasClass('inline-editable-field') && !($input.find("option:selected").text() == 'Confirmed')) {
                    $input.val($input.data('original-value'));
                    $input.toggle();
                    $input.siblings('span.original-value').toggle();
                }
                else if($input.find("option:selected").text() == 'Confirmed'){
                    // Do nothing
                }
                else {
                    $input.parent().html($input.data('original-value'));
                }

            }
            props.editing = null;
            $(row).find('button.edit, button.save, button.cancel').toggle();
        }

        function makeRowReadOnly(row, props) {
            var jqInputs = $('td.editable input, td.editable select', row);
            //iterate over inputs
            for (var i = 0; i < jqInputs.length; i++) {
                var $input = $(jqInputs[i]);
                if ($input.hasClass('inline-editable-field') && !($input.find("option:selected").text() == 'Confirmed')) {
                    $input.toggle();
                    var newValue = null;
                    if ($input.is('select')) {
                        newValue = $input.find("option:selected").text();
                    } else {
                        newValue = $input.val();
                    }
                    $input.siblings('span.original-value').html(newValue).toggle();
                }
                else if ($input.find("option:selected").text() == 'Confirmed'){
                    // Do nothing
                }
                else {
                    $input.parent().html($input.val());
                }
            }
            props.editing = null;
            $(row).find('button.edit, button.save, button.cancel').toggle();

        }

        function saveRow(button, props, successCallback, errorCallback) {
            var row = $(button).parents('tr')[0];
            var inputs = $('td.editable input, td.editable select, td>div.editable.provider-datafields input', row);
            clearErrors(row);
            if(!validateRow(row)){
                return;
            }
            var data = JSON.stringify(inputs.serializeObject());
            var url = settings.savePutURL($(button));
            $.ajax({
                    type: "PUT",
                    url: url,
                    data: data,
                    contentType: 'application/json'
                })
                .done(function(data) {
                    //update original value fields on successful save
                    successCallback(data);
                })
                .fail(function() {
                    errorCallback;
                });
        }

        function clearErrors(row){
            $('td.editable input.required.error, td.editable select.required.error', row).each(function(){
                $(this).removeClass('error');
                $(this).parent().find('span.error').remove();
            });

        }

        function validateRow(row){

            var rowIsValid = true;
            var inputs = $('td.editable input.required, td.editable select.required', row);
            inputs.each(function(){
                if(!$(this).val()){
                    rowIsValid = false;
                    $(this).addClass('error');
                    $(this).after('<span class="error">Required</span>');
                }
            });
            return rowIsValid;

        }


    }


}(jQuery));
