// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function showCancellationDetails(description, numberOfExaminations, reasonForCancellation, cancellationDetails) {
  //alert(name);
  $("#contentionName").html(description);
  $("#examinations").html(numberOfExaminations);
  $("#reasonForCancellation").html(reasonForCancellation);
  $("#cancellationDetails").html(cancellationDetails);

  $("#cancelledContentionModalId").dialog({
    modal: true,
    draggable: false,
    resizable: false,
    width: 600,
    dialogClass: 'ui-dialog-osx',
    buttons: {
      "Close": function() {
        $(this).dialog("close");
      }
    }
  });
  $(".ui-dialog-titlebar").hide();
}

function exam_request_jqdr() {

  var exam_request_dbq_category_mapping = {
    1: "Neurological",
    2: "Neurological",
    4: "Ear, Nose, and Throat",
    5: "Muscular",
    7: "Muscular",
    8: "Muscular",
    9: "Muscular",
    10: "General",
    13: "Endocrinological",
    14: "Endocrinological",
    16: "Hematology",
    18: "Cardiology",
    19: "Gastrointestinal",
    20: "Neurological",
    21: "Neurological",
    22: "Ear, Nose, and Throat",
    23: "General",
    24: "General",
    25: "General",
    26: "Muscular",
    27: "Gastrointestinal",
    28: "Gastrointestinal",
    29: "Gastrointestinal",
    30: "Gastrointestinal",
    31: "Ear, Nose, and Throat",
    32: "Dental And Oral",
    33: "Ear, Nose, and Throat",
    34: "Infectious Diseases",
    35: "Infectious Diseases",
    36: "Neurological",
    37: "Gastrointestinal",
    38: "Gastrointestinal",
    39: "Muscular",
    40: "Infectious Diseases",
    41: "Cardiology",
    42: "General",
    43: "Dental And Oral",
    44: "Neurological",
    45: "Dermatology",
    46: "Pulmonology",
    47: "Infectious Diseases",
    48: "Pulmonology",
    49: "Endocrinological",
    50: "Neurological",
    51: "General",
    52: "Neurological",
    53: "Neurological",
    54: "Infectious Diseases",
    55: "Gastrointestinal",
    56: "Gastrointestinal",
    57: "Hematology",
    58: "Gastrointestinal",
    59: "Muscular",
    60: "Dental And Oral",
    61: "Neurological",
    62: "Muscular",
    63: "Cardiology"
  };

  $('#_request_date').datepicker({
    selectOtherMonths: true,
    changeMonth: true,
    changeYear: true
  });

  $('#secondary_action').change(function(){

    var secondary_action_button = $('#exam_request_secondary_action');

    if (this.value != ''){
      secondary_action_button.prop( "disabled", false);
    } else {
      secondary_action_button.prop( "disabled", true);
    }
  });

  $('#exam_request_form').submit(function(event){
    this.action = $('#secondary_action').val();
  });

  $('#contention_to_add_dbqs').change(function(){

    var contention_description = $('#contention_description');
    contention_description.val(this.options[this.selectedIndex].text);

    if (this.value == ''){

      $('#dbqs_to_add').html('').change();
      contention_description.val('');
      return;
    }

    // make an ajax call to get the data
    $.get($('#get_dbqs_url').val() + '?contention_id=' + this.value, function (dbqs) {

      var option_tags = "";

      $.each(dbqs, function (index, dbq) {

        var dbq_title = dbq[0].replace(/(\\r\\n)+/g, '');
        option_tags += '<option value="' + dbq[1] + '}}' + dbq_title + '">' + dbq_title + '</option>';
      });

      $('#dbqs_to_add').html(option_tags);
      $('#dbq_filter').change();

    }.bind(this));
  });

  $('#dbq_filter').change(function(){

    var dbqs_to_add = $('#dbqs_to_add');
    $('option', 'span:hidden').unwrap();
    var dbq_options = dbqs_to_add.find("option");
    var filter_value = this.value;

    if (filter_value == ''){

      dbq_options.show();
      dbq_options.prop( "selected", false);

    } else {

      dbq_options.each(function(){

        this.selected = false;
        var option = $(this);
        var dbq_id = this.value.split("}}")[0];

        if (exam_request_dbq_category_mapping[dbq_id] == filter_value){
          option.show();
        } else {
          // IE 11 does not respond to jquery hide
          option.wrap('span').parent().hide();
        }
      });
    }

    dbqs_to_add.change();
  });

  $('#dbqs_to_add').change(function(){

    var selected_count = 0;
    var selected_list = '<br>';
    var dbq_confirm_list = '';
    var selected_dbq_heading = $('#selected_dbq_heading');
    var selected_dbq_list = $('#selected_dbq_list');
    var add_dbqs_submit = $('#add_dbqs_submit');
    var contention_text = $('#contention_to_add_dbqs').find('option:selected').text();

    $(this).find('option:selected').each(function () {

      selected_count++;
      selected_list += this.innerText + '<br>';
      dbq_confirm_list += this.innerText + ',<br>';
    });

    if (selected_count < 1){

      selected_dbq_heading.hide();
      selected_dbq_list.hide();
      add_dbqs_submit.prop( "disabled", true );

    } else {

      selected_dbq_heading.html('Selected DBQs (' + selected_count + '):');
      selected_dbq_list.html(selected_list);

      selected_dbq_heading.show();
      selected_dbq_list.show();
      add_dbqs_submit.prop( "disabled", false);
      add_dbqs_submit.data('confirm', 'Do you want to add the following DBQs to the contention "' + contention_text + '"? <br><br> DBQs: ' + dbq_confirm_list.replace(/(,<br>)$/, ''));
    }
  });

  function check_state_for_cancel_dbqs_submit(){

    var cancel_dbqs_submit = $('#cancel_dbqs_submit');
    var total_dbq_checkboxes = $('.cancel_dbq_select');
    var checked_checkboxes = total_dbq_checkboxes.filter(':checked');
    var all_dbqs_selected_warning = $('#all_dbqs_selected_warning');
    var disable = false;

    $('form').find(':required').prop('required', false);

    all_dbqs_selected_warning.hide();

    if (checked_checkboxes.length == 0) {
      disable = true;

    } else if (total_dbq_checkboxes.length == checked_checkboxes.length ){

      all_dbqs_selected_warning.show();
      all_dbqs_selected_warning.focus();
      disable = true;

    } else {

      checked_checkboxes.each(function () {

        var row_id = $(this).attr('id').replace('cancel_dbq_select', '');

        if ($('#cancel_reason' + row_id).val() == '') {

          $('#cancel_reason' + row_id).prop('required',true);

          disable = true;
        }
      });
    }

    cancel_dbqs_submit.prop( "disabled", disable);
  }

  $('#cancel_dbq_select_all').click(function(){

    var checkbox = $(this);
    var fields_divs = $('.cancel_dbq_fields');
    var checkboxes = $('.cancel_dbq_data_row').find('input:checkbox');

    if (checkbox.prop('checked')){

      fields_divs.show();
      checkboxes.prop('checked', true);
    } else {

      fields_divs.hide();
      checkboxes.prop('checked', false);
    }

    check_state_for_cancel_dbqs_submit();
  });

  $('.cancel_dbq_data_row').find('input:checkbox').click(function(){

    var checkbox = $(this);
    var row_id = checkbox.attr('id').replace('cancel_dbq_select', '');
    var fields_div = $('#cancel_dbq_fields' + row_id);

    if (checkbox.prop('checked')){
      fields_div.show();
    } else {
      fields_div.hide();
    }

    check_state_for_cancel_dbqs_submit();
  });

  $('.cancel_dbqs_reason').change(function(){
    check_state_for_cancel_dbqs_submit();
  });

  $('#cancel_dbqs_submit').click(function(){

    var selected_list = '<br>';
    var checked_checkboxes = $('.cancel_dbq_data_row').find('input:checkbox:checked');

    checked_checkboxes.each(function(){

      var checkbox = $(this);
      var row_id = checkbox.attr('id').replace('cancel_dbq_select_', '');

      selected_list += $('#dbq_title_' + row_id).val() + ' (' + $('#contention_description_' + row_id).val() + '),<br>';
    });

    $(this).data('confirm', 'Do you want to cancel the following DBQs? <br><br>' + selected_list.replace(/(,<br>)$/, ''));

  });

  $('#clarification_primary_phone, #clarification_alternate_phone').on('keydown', function(e) {
    var key = e.keyCode || e.charCode;
    if (e.shiftKey) {
      return false;
    }
    if ((key >= 48 && key <= 57)
      || (key >= 96 && key <= 105)
      || key == 8 || key == 9
      || key == 13 || key == 46
      || (key >= 37 && key <= 40)) {
      return true;
    } else {
      return false;
    }
  });

  $('#clarification_primary_phone, #clarification_alternate_phone').attr('maxlength','12');

  $('#clarification_primary_phone, #clarification_alternate_phone').keyup(function(e) {
    var phoneNumber = $(this).val();
    if (e.keyCode != 8) {
      if (phoneNumber.length == 3 || phoneNumber.length == 7) {
        $(this).val(phoneNumber + "-");
      }
      else if ((phoneNumber.length == 4 || phoneNumber.length == 8) && (phoneNumber.slice(-1) != "-")) {
        var lastDigit = phoneNumber.slice(-1);
        $(this).val(phoneNumber.slice(0,-1) + "-" + lastDigit);
      }
    }
  });

  function check_state_for_clarification_submit(){

    var clarification_submit = $('#clarification_submit');
    var clarification_reason = $('#clarification_reason');

    var disable = false;

    if ($('#clarification_primary_phone').val() == '' || ($('#clarification_alternate_phone').val() == '' && $('#clarification_no_alternate_phone').prop('checked') == false)){

      clarification_submit.prop( "disabled", true);
      return;
    }

    if (clarification_reason.val() == 'Contention Related'){

      var checked_checkboxes = $('input:checkbox:checked.clarification_contention_select')

      if (checked_checkboxes.length == 0){
        disable = true;
      } else {

        checked_checkboxes.each(function () {

          var row_id = $(this).attr('id').replace('clarification_contention_select_', '');

          if ($('#contention_comments_' + row_id).val() == '') {

            disable = true;
            return false;
          }
        });
      }
    } else if ((clarification_reason.val() == 'Exam Request Related' && $('#clarification_comments').val() == '') || clarification_reason.val() == ''){
      disable = true;
    }

    clarification_submit.prop( "disabled", disable);
  }

  $('#clarification_reason').change(function(){

    var clarification_comments_section = $('#clarification_comments_section');
    var clarification_contention_section = $('#clarification_contention_section');

    if (this.value == 'Contention Related'){

      clarification_comments_section.hide();
      clarification_contention_section.show();
    } else {

      clarification_comments_section.show();
      clarification_contention_section.hide();
    }

    check_state_for_clarification_submit();
  });

  $('.clarification_required_field').on('keyup change paste', function(){
    check_state_for_clarification_submit();
  });

  $('#clarification_no_alternate_phone').change(function(){
    $('#clarification_alternate_phone').prop( "disabled", this.checked);
  });

  $('#clarification_contention_select_all').click(function(){

    var checkbox = $(this);
    var fields_divs = $('.clarification_contention_fields');
    var checkboxes = $('.clarification_contention_data_row').find('input:checkbox');

    if (checkbox.prop('checked')){

      fields_divs.show();
      checkboxes.prop('checked', true);
    } else {

      fields_divs.hide();
      checkboxes.prop('checked', false);
    }

    check_state_for_clarification_submit();
  });

  $('.clarification_contention_data_row').find('input:checkbox').click(function(){

    var checkbox = $(this);
    var row_id = checkbox.attr('id').replace('clarification_contention_select_', '');
    var fields_div = $('#clarification_contention_fields_' + row_id);

    if (checkbox.prop('checked')){
      fields_div.show();
    } else {
      fields_div.hide();
    }

    check_state_for_clarification_submit();
  });

  $('#clarification_submit').click(function(){

    var clarification_reason = $('#clarification_reason');
    var confirmation_message = 'Are you sure you want to request clarification ';

    if (clarification_reason.val() == 'Contention Related'){

      confirmation_message += 'for the following contentions? <br>';
      var checked_checkboxes = $('.clarification_contention_data_row').find('input:checkbox:checked');

      checked_checkboxes.each(function(){

        var checkbox = $(this);
        var row_id = checkbox.attr('id').replace('clarification_contention_select_', '');

        confirmation_message += $('#contention_description_' + row_id).val() + ',<br>';
      });

      confirmation_message = confirmation_message.replace(/(,<br>)$/, '');
    } else {
      confirmation_message += 'on this exam?';
    }

    $(this).data('confirm',  confirmation_message);
  });

  $('#select_contentions_submit').click(function(){

    $("#clarification_form").validate({
      debug: true,
      rules: get_clarification_form_rules(),
      messages: get_clarification_form_rule_messages(),
      submitHandler:  function(form) {
        console.log($(form).valid());
        if ($(form).valid()){
          form.submit();
        }
        return false; // prevent normal form posting
      }
    });

    $.validator.addMethod('primary', function (value) {
      return /^[(]{0,1}[0-9]{3}[)]{0,1}[-\s\.]{0,1}[0-9]{3}[-\s\.]{0,1}[0-9]{4}$/.test(value);
    }, 'Please enter a valid US phone number.');

    function get_clarification_form_rules(){
      var form_rules = {'primary': {primary: true},'alternate': {primary: true}};
      var text_fields =  get_clarification_form_names();
      for (var i = 0; i < text_fields.length; i++) {
        form_rules[text_fields[i]] = {required: true};
      }
      return form_rules;
    }

    function get_clarification_form_rule_messages(){
      var messages = {};
      var text_fields =  get_clarification_form_names();
      for (var i = 0; i < text_fields.length; i++) {
        messages[text_fields[i]] = 'Please enter the clarification field';
      }
      return messages;
    }

    function get_clarification_form_names(){
      return $.map($('.js-clarification'), function (key, value) {
        return key.getAttribute('name');
      });
    }
  });
}

$(function() {
  function getExamRequestHistoryHeaders() {
    return [
      { data: "date", className: "erh-date-created", orderable: false },
      { data: "event", className: "erh-event", orderable: false },
      { data: "notes", className: "erh-notes", orderable: false },
    ];
  }

  $("#exam-request-history-table").DataTable({
    language: {
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getExamRequestHistoryHeaders(),
    ajax: {
      "url": "/exam_request/paged_erh_list",
      "data": function(d) {
        d.erId = $("#er-id").val();
      }
    },
    processing: true,
    serverSide: true,
    bLengthChange: false,
    pageLength: 5,
    searching: false
  });

});
