// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function dbq_forms_jqdr() {

  function change_element_type(){

    if (this.value == ''){
      return;
    }

    var section_id = this.name.match(/sections_attributes\]\[(\d*)\]/)[1];
    var element_id = this.name.match(/elements_attributes\]\[(\d*)\]/)[1];
    var field_name = 'dbq_form[dbq_sections_attributes][' + section_id + '][dbq_elements_attributes][' + element_id + ']';
    var field_id = 'dbq_form_dbq_sections_attributes_' + section_id + '_dbq_elements_attributes_' + element_id;
    var parent_fieldset = $(this).closest('fieldset');
    var values_wrapper = parent_fieldset.find('div.dbq_form_dbq_sections_dbq_elements_possible_values');
    var additional_fields = '';
    var is_new = parent_fieldset.find('.edit_element_label').length == 0;
    var buttons_added = false;

    // if this is a new element we need to create the element label field
    if (is_new){

      var label = '<div class="edit_element_label">'
          + '<input placeholder="Label for Element - (leave blank if not needed)" type="text" name="' + field_name + '[label]" '
          + 'id="dbq_form_dbq_sections_attributes_' + section_id + '_dbq_elements_attributes_' + element_id + '_label"></div>';

      parent_fieldset.find('.dbq_layout_row').after(label);
    }

    // remove any existing value fields so we don't pass unwanted values to the wrong element types
    parent_fieldset.find('.edit_dbq_example_field').remove();

    // if this is a text type field we need to set an appropriate example field and possibly a value field for straight text. Otherwise there is much different logic for selects and boolean fields
    if (this.value.indexOf('text') >= 0){

      values_wrapper.remove();
      parent_fieldset.find('button#possible-values_' + section_id + '_' + element_id).remove();

      switch (this.value){

        case 'text':

          additional_fields = '<textarea class="edit_dbq_example_field" placeholder="Enter text to display here" name="dbq_form[dbq_sections_attributes][' + section_id
              + '][dbq_elements_attributes][' + element_id + '][value]" id="' + field_id + '_value"></textarea>';
          break;

        case 'text field':

          additional_fields = '<input class="edit_dbq_example_field" disabled="disabled" type="text" name="' + field_name + '[value]" id="' + field_id + '_value" value="">';
          break;

        case 'text area':

          additional_fields = '<textarea class="edit_dbq_example_field" disabled="disabled" name="' + field_name + '[value]" id="' + field_id + '_value" value=""></textarea>';
          break;
      }
    } else {

      var value_label = 'Value';
      var value_decorative_example = '';
      var buttons = '';
      var is_select = this.value.indexOf('select') >= 0;
      var is_boolean_group = this.value.indexOf('group') >= 0;

      // if this is a checkbox or radio button group or a select field change the label and set the buttons
      if (is_boolean_group || is_select){

        value_label = 'values:';
        buttons = '<button type="button" name="add-possible-value" id="possible-values_' + section_id + '_' + element_id + '" class="add_value_button value_buttons" aria-label="Add value">Add</button>';
        buttons += '&nbsp;<button type="button" name="remove-possible-value" id="possible-values_' + section_id + '_' + element_id + '" class="remove_value_button value_buttons" aria-label="Remove value">Remove</button>';
      }

      // if this is a checkbox or radio button type field set the appropriate decorative example
      if (!is_select){

        if (this.value.indexOf('check') >= 0){
          value_decorative_example = '<input type="checkbox" disabled="true" style="display: inline;" class="cui_decorative_input_field"/>'
        } else {
          value_decorative_example = '<input type="radio" disabled="true" style="display: inline;" class="cui_decorative_input_field"/>'
        }
      }

      // if this is a new element or was a text type field then create all the fields for this section. Otherwise we will change only the parts we have to so we don't lose any entered values
      if (is_new || values_wrapper.length == 0){

        additional_fields = '<div class="input text optional dbq_form_dbq_sections_dbq_elements_possible_values possible-values_' + section_id + '_' + element_id + '">'
            + '<label class="text optional" for="' + field_id + '_possible_values">' + value_label + '</label>'
            + '<div>' + value_decorative_example + '<input class="text optional" placeholder="New Value Here" type="text" name="' + field_name + '[possible_values][]" id="' + field_id + '_" style="display: inline;"></div></div>' + buttons;
        buttons_added = true;
      } else {

        var existing_buttons = parent_fieldset.find('button');

        // remove any decorative examples and set the label
        values_wrapper.find('input.cui_decorative_input_field').remove();
        values_wrapper.find('label').html(value_label);

        // if this is not a select field we need to change the decorative examples and possibly remove the 'Add Value' and 'Remove Value' buttons
        if (!is_select){

          var value_inputs = values_wrapper.find('input');

          if (!is_boolean_group){

            existing_buttons.remove();
            value_inputs.slice(1).closest('div').remove();
          }

          value_inputs.before(value_decorative_example);
        }

        // if this is a checkbox or radio button group or a select field and there are currently no buttons then add them.
        if ((is_boolean_group || is_select) && existing_buttons.length == 0){

          values_wrapper.after(buttons);
          buttons_added = true;
        }
      }
    }

    if (additional_fields != ''){
      parent_fieldset.find('.edit_element_label').after(additional_fields)
    }

    // add the onclick handlers for the add and remove value buttons if they were added
    if (buttons_added){

      parent_fieldset.find('button.add_value_button').click(add_element_value);
      parent_fieldset.find('button.remove_value_button').click(remove_element_value);
    }

  }

  // make sure when the "Add Element" buttons are clicked we set onchange events on the new 'Element Type' select fields
  $('form.new_dbq_form, form.edit_dbq_form').on('fields_added.nested_form_fields', function(event){
    $(event.target).find('select').change(change_element_type);
  });

  // add onchange events to all the 'Element Type' select fields
  $('.dbq_edit_form select').change(change_element_type);

  $(document).on("fields_removed.nested_form_fields", function(event, param) {

    switch (param.object_class) {
      case "dbq_section":
        return console.log("Section removed !");
      case "dbq_element":
        return console.log("Element removed !");      
      default:
        return console.log("INFO: Fields were successfully added, callback not handled.");
    }
  });

  function add_element_value() {

    var id = $(this).attr("id");
    var new_value_div = $(".input." + id + " div:last-child").clone();
    var new_value_field = new_value_div.find("input[type='text']");

    new_value_field.val('');

    return $(".input." + id).append(new_value_div);
  }

  $(".add_value_button").click(add_element_value);

  function remove_element_value() {
    $(".input." + ($(this).attr("id")) + " div:last-child").remove();
  }

  $(".remove_value_button").click(remove_element_value);

}
