// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function dashboards_jqdr() {

  function getExamRequestHeaders() {
      return [
        {title: "Date Created", data: "date_created", orderable: false},
        {title: "Status", data: "status", orderable: false},
        {title: "Veteran Name", data: "veteran_name", orderable: false},
        {title: "File Number", data: "file_number", orderable: false},
        {title: "Associated Site", data: "associated_site", orderable: false},
        {
            title: "",
            orderable: false,
            render: function (data, type, row) {
                link_text = "Take action"
                if (row.status == "Pending Clarification"){ link_text = "On hold" }
                if (row.status == "Clarification Received"){ link_text = "View Response" }
                return '<a href="erp/view_exam_request/' + row.identifier + '" aria-label="Take action on exam request for ' + row.veteran_name + ', file number: ' + row.file_number + '">'+link_text+' </a>';
            }
        }
    ];
  }

  var $examRequestTable = $('#examRequestsList').DataTable({
    columns: getExamRequestHeaders(),
    ajax: '/dashboards/get_exam_requests',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    bSort: true,
    bFilter: false,
    searching: false,
    pageLength: 10
  });

  $("#cancel-examination-index-table").DataTable({
    language: {
      info: "Showing page _PAGE_ of _PAGES_ from a total of _MAX_ records"
    },
    columns: getCancelExaminationHeaders(),
    ajax: '/dashboards/cancel_paged_list',
    processing: true,
    serverSide: true,
    bLengthChange: false,
    pageLength: 15,
    searching: false
  });

  exam_request_jqdr();
}

function getCancelExaminationHeaders() {
  return [
    {data: "exam-date-time",   className: "ce-exam-date-time"},
    {data: "veteran-name",     className: "ce-veteran-name"},
    {data: "contention",       className: "ce-contention"},
    {data: "state",            className: "ce-state"},
    {data: "days-in-state",    className: "ce-days-in-state", orderable: false},
    {data: "site",             className: "ce-site"},
    {data: "clinician",        className: "ce-clinician"},
    {data: "action", render: function(data, type, row) {
        return "<a href=\"" + data +"\" aria-label=\"Cancle exam for " + row['veteran-name'] + " on " + row['exam-date-time'] + "\">Cancel</a>";
      }, orderable: false
    }
  ];
}


function showAlertDetails(alert_description, site) {
    document.getElementById('alertDetailsModalId').style.display='none';
    document.getElementById('alertDetailsModalId').style.display='block';

    $("#alertDetails-details").html(alert_description);
    $("#alertDetails-site").html(site);

    //Scroll to bottom of table
    var height = $("#alertDetailId").height();
    $("#alertDetailId").scrollTop(height);
}

var alertFlag = "show";
$("#alertHeaderId").click(function() {
  if(alertFlag == "show") {
    alertFlag = "hide"
    $("#alertHeaderId").html("+");
    $("#alertDetailId").hide();
  } else if(alertFlag == "hide") {
    alertFlag = "show"
    $("#alertHeaderId").html("--");
    $("#alertDetailId").show();
  }
});
