// an override for the rails_jquery_ujs confirm action in order to make these confirm dialogs 508 compliant
$.rails.allowAction = function(link){

    if (link.data("confirm") == undefined){
        return true;
    }

    $.rails.showConfirmationDialog(link);
    return false;
}

// override for the user clicking the confirm button
$.rails.confirmed = function(link){
    link.data("confirm", null);
    link.trigger("click.rails");
}

// Custom confirm dialog
$.rails.showConfirmationDialog = function(link){

    var message = link.data("confirm");
    var dialogID = "cui_generated_confirm_dialog";
    var body = $("body");
    var position = {my: "center", at: "center", of: body};
    var dialogString = '<div id="' + dialogID + '"><div class="cui-no-outline" role="alert">' + message + '</div></div>';
    var titleText = "VA Clinician User Interface";
    var okButtonText = "OK";
    var cancelButtonText = "Cancel";

    if (link.data("confirmTitleText") != undefined){
      titleText = link.data("confirmTitleText");
    }

    if (link.data("confirmOkText") != undefined){
      okButtonText = link.data("confirmOkText");
    }

    if (link.data("confirmCancelText") != undefined){
      cancelButtonText = link.data("confirmCancelText");
    }

    body.prepend(dialogString);
    var dialog = $("#" + dialogID);

    dialog.dialog({
        beforeClose: function () {
            dialog.remove();
        },
        title: titleText,
        resizable: false,
        height: "auto",
        width: 500,
        modal: true,
        position: position,
        dialogClass: "cui-confirmation-dialog cui-dialog-no-close-button",
        buttons: {
            Cancel: {
                "class": "btn btn-default",
                text: cancelButtonText,
                click: function () {
                    $(this).dialog("close");
                }
            },
            OK: {
                text: okButtonText,
                "class": "btn btn-primary",
                "id": dialogID + "_ok_button",
                click: function () {

                    $(this).dialog("close");
                    $.rails.confirmed(link);
                }
            }
        }
    });

    dialog.parent().children().children(".ui-dialog-titlebar-close").remove();
}