function cpp_date_logic(){
  $(".from_date").datepicker()
    .on('change', function(ev) {
        $(".to_date").datepicker('setDate', null);
        $(".to_date").datepicker("option", "minDate", this.value)
        $(".to_date").val($(".from_date").val())
    })

  $('.from_date, .to_date').on('blur', function (){
    var txtVal =  this.value;
    if(isDate(txtVal) || txtVal == "") {
      $('#toDateAndFromDateError').hide();
    }
    else{
      $('#toDateAndFromDateError').show();
      $(this).focus();
      this.value = "";
      if (this.class = 'from_date'){
        $('.to_date').val('');
        $(".to_date").datepicker("option", "minDate", this.value);
      }
    }
  })

  $('.from_date, .to_date').on('change', function(){
    if ($('.from_date').val().length != 0 && $('.to_date').val().length != 0) {
      $('#toDateAndFromDateError').hide();
    }
  })
  $('.to_date').on('change', function() {
    if($('.from_date').val() > $('.to_date').val() ) {
     $('.to_date').val($('.from_date').val());
    }
  })

  $('.dob_date, .from_date, .to_date').attr('maxlength','10');

  $('.dob_date').on('blur', function() {
    var txtVal = this.value;
    if ((isDate(txtVal) && isNotFutureDate(txtVal)) || txtVal == ""){
      $('#dateOfBirthDateError').hide();
    }
    else {
      $('#dateOfBirthDateError').show();
      $(this).focus();
      this.value = "";
    }
  })

  $('.dob_date').on('change', function() {
    if ($('.dob_date').val().length != 0) {
      $('#dateOfBirthDateError').hide();
    }
  })

  $('.dob_date, .from_date, .to_date').keyup(function(e) {
      var dobDate = $(this).val();
      if (e.keyCode != 191) {
          if (e.keyCode != 8) {
              if (dobDate.length == 2 || dobDate.length == 5) {
                  $(this).val(dobDate + "/");
              }
              else if ((dobDate.length == 3 || dobDate.length == 6) && (dobDate.slice(-1) != "/")) {
                  var lastDigit = dobDate.slice(-1);
                  $(this).val(dobDate.slice(0,-1) + "/" + lastDigit);
              }
              //to handle copy & paste of 8 digit
              else if (e.keyCode == 86 && dobDate.length == 8) {
                  $(this).val(dobDate.substr(0, 2) + "/" + dobDate.substr(2, 2) + "/" + dobDate.substr(4, 4));
              }
          }
      }


  });

}

function isDate(txtDate){  
  var rxDatePattern = /^(\d{1,2})(\/|-)(\d{1,2})(\/|-)(19|20)\d{2}$/; //Declare Regex
  var dtArray = txtDate.match(rxDatePattern); // is format OK?

  if (dtArray == null) 
    return false;
  
  //Checks for mm/dd/yyyy format.
  dtMonth = dtArray[1];
  dtDay= dtArray[3];
  dtYear = dtArray[5];        
  
  if (dtMonth < 1 || dtMonth > 12)
    return false;
  else if (dtDay < 1 || dtDay> 31) 
    return false;
  else if ((dtMonth==4 || dtMonth==6 || dtMonth==9 || dtMonth==11) && dtDay ==31) 
    return false;
  else if (dtMonth == 2) 
  {
    var isleap = (dtYear % 4 == 0 && (dtYear % 100 != 0 || dtYear % 400 == 0));
    if (dtDay> 29 || (dtDay ==29 && !isleap)) 
      return false;
  }
  return true;
}

function isNotFutureDate(idate){
  var today = new Date().getTime(),
      idate = idate.split("/");
  idate = new Date(idate[2], idate[0] - 1, idate[1]).getTime();
  return (today - idate) >= 0 ? true : false;
}



