// Place all the behaviors and hooks related to the matching controller here.
// All this logic will automatically be available in application.js.

function consultation_referral_documents_jqdr() {
  var oRefDocsTable = $('table.referralDocumentsTable').DataTable( {
      bLengthChange: false,
      bFilter: false,
      bSort: true,
      searching: false,
      aaSorting: [[4, 'desc']],
      aoColumnDefs: [{
          bSortable: false,
          aTargets: [5]
      }],
      pageLength: 10
  });

  var oReferralDocumentsDeletedTable = $('table#referralDocumentsDeletedTable').DataTable( {
      bLengthChange: false,
      bFilter: false,
      bSort: true,
      searching: false,
      aaSorting: [],
      pageLength: 5,
      columns:     [
          { title: 'File Name', data: 'document_link', orderable: true },
          { title: 'Document Type', data: 'doc_type_name', orderable: true },
          { title: 'Uploaded By', data: 'uploader_name', orderable: true },
          { title: 'Deleted By', data: 'deleted_by', orderable: true },
          { title: 'Deleted Date', data: 'formatted_deleted_at', orderable: true }
      ]
  });

  var deleteDocumentModal = $('div#deleteDocumentModal');

  oRefDocsTable.on('click', 'button.deleteRefDoc', function() {
      var data = oRefDocsTable.row($(this).parents('tr')).data();
      var ref_doc_id = $(this).data('referral-doc-id');
      $('span#del_doc_data').text(ref_doc_id);
      $('span#del_filename').html(data[0]);
      $('#delete_doc_reason').val('');
      $('#reason_validation_error').hide();
  });

  $('#doc-delete-delete-button').on('click', function(){
      console.log("Test Delete")
      var doc_id = $('span#del_doc_data').text();
      var reason = $('#delete_doc_reason').val();

      if (reason.length > 0) {
          $.post('/delete_referral_doc', {referral_doc_id: doc_id, reason: reason}, function (data) {
              if (data.success === true) {
                  oRefDocsTable.row('#tr_refdoc_' + doc_id).remove().draw();
                  deleteDocumentModal.foundation('close');
                  addDeletedRefDocData(doc_id);
              } else {
                  $("span#reason_validation_error").text(data.msg).show();
              }
          });
      } else {
          $("span#reason_validation_error").show();
          $('#delete_doc_reason').focus();
      }
  });

  function addDeletedRefDocData(ref_doc_id) {
    $.get("/deleted_referral_docs_for_user", {referral_doc_id: ref_doc_id}, function(data) {
        //add the rows in and re-sort the table to have the most recent deleted document as the first record
        oReferralDocumentsDeletedTable.rows.add(data).draw(false);
        oReferralDocumentsDeletedTable.order([4, 'desc']).draw();
        oReferralDocumentsDeletedTable.page('first').draw(false);

        // open the deleted documents table if it is not visible based on the toggle image
        if ($('i#toggleDeletedData').hasClass('fa-plus-square')) {
            $('i#toggleDeletedData').click();
        }
    });
  }

  $('i#toggleDeletedData')
  .on('keydown', function (e) {
    switch(e.keyCode) {
      case 13: //enter
      case 32: //spacebar
        // toggle the datatable visibility via the mouse click event
        this.click();
        break;
      case 9: //tab - allow focus to move off of the image
        break;
      default:
        return false;
    }
  })
  .on('click', function() {
    if ($(this).hasClass('initialize')) {
      $.get("/deleted_referral_docs_for_user", {referral_ids: $(this).data('referral-ids')}, function(data) {
        oReferralDocumentsDeletedTable.clear();
        oReferralDocumentsDeletedTable.rows.add(data).draw()
      });
    }

    var hide = $(this).hasClass('fa-minus-square');
    var img = hide ? 'fa fa-plus-square' : 'fa fa-minus-square'
    $('.deleted_rows').fadeToggle('slow', 'linear');
    $(this).removeClass().addClass(img);
  }).click();

  $('table.referralDocumentsTable.data-table.inline-editable').each(function () {
      $(this).inlineEditable({
          savePutURL: inlineEditSaveUrl

      });
  });

  function inlineEditSaveUrl(saveButton) {
      var referralId = $(saveButton).data("referral-id");
      var documentId = $(saveButton).data("referral-document-id");
      return "/referrals/" + referralId + "/referral_documents/" + documentId + ".json";
  }

  $('.inline_edit')
  .on('show', function() {
      toggleDeleteBtn(this, 'hide');
  })
  .on('hide', function() {
      toggleDeleteBtn(this, 'show');
  });

  function toggleDeleteBtn(inline_edit, action) {
    var ref_doc_id = $(inline_edit).data('referral-doc-id');
    var delete_btn = $("button.deleteRefDoc[data-referral-doc-id='" + ref_doc_id + "']");

    if (delete_btn !== undefined) {
        if (action === 'show') {
            delete_btn.show();
        } else {
            delete_btn.hide();
        }
    }
  }

  $('.add-referral-document-button').on('click', function(){
    var authorizationNumber = $(this).data("authorizationNumber");
    $('.add-referral-document-form').hide();
    $('.add-referral-document-button').show();
    $('#addReferralDocument_' + authorizationNumber).hide();
    $('#referralDocumentsForm_' + authorizationNumber).show();
  });

  $('.close-document-forms').on('click', function() {
    $('.add-referral-document-form').hide();
    $('.add-referral-document-button').show();
  });

  $('input[type=file].referralDocUploader').hide();

  $('button.referralDocUploader').on('click', function () {
      var authorizationNumber = $(this).data("authorizationNumber");
      $('#referralDocFileInput_' + authorizationNumber).trigger('click');
      return false;
  });

  $('input.referralDocUploader').change(function (e) {
      var fileObj = e.target.files[0];
      $('input[type=text].docNameField').val(fileObj.name)
  });

  $('button#vhaDocUploaderButton').on('click', function() {
      $('#vhaDocUploader').trigger('click');
      return false;
  });

  $('input#vhaDocUploader').change(function (e) {
      var fileObj = e.target.files[0];
      $('input[type=text].docNameField').val(fileObj.name)
  });

  // handle ajax event when user clicks on Reviewed checkbox, and replaces checkbox
    // with approver and datestamp if successful.
    var $documentsTable = $('.referralDocumentsTable');
    $documentsTable.on('change', 'input.approval-checkbox', function (e) {
        if (e.target) {
            var checked = e.target.checked;
            var $checkbox = $(e.target);
            var docId = parseInt($checkbox.data('doc-id'));
            if (!isNaN(docId)) {
                var row_id = 'tr_refdoc_' + docId;
                var message = false;
                $.post('/approve_referral_doc', {referral_doc_id: docId, checked: checked}, function(data) {
                    if (data.success) {
                      if(checked) {
                        $checkbox.closest('td').html(data.reviewed_by).effect("highlight", {color: 'green'}, 1000);
                        $('#header').after('<div class="alerts alert-box success animated fadeIn" id="reviewed_document"><div class="row"><div class="small-12 columns">Document was successfully reviewed.</div></div></div>');
                        message = true;
                      }
                    } else {
                        $checkbox.prop('checked', !checked);
                        $checkbox.closest('td').effect("highlight", {color: 'red'}, 1000);
                        $('#header').after('<div class="alerts alert-box alert animated fadeIn" id="failed_to_review_document"><div class="row"><div class="small-12 columns">Failed to review document.</div></div></div>');
                        message = true;
                    }

                    // change visibility of the delete link if available based on the approval change
                    var delete_link = $('#' + row_id + ' > td.links > button.text-button.deleteRefDoc');
                    checked ? delete_link.hide() : delete_link.show();

                    $('#reviewed_document').fadeOut(10000);
                    if(message) window.scrollTo(0,0);
                });
            }
        }
    });
}