require 'rails_helper'

RSpec.describe "minor_systems/edit", :type => :view do
  before(:each) do
    @minor_system = assign(:minor_system, MinorSystem.create!(
      :name => "MyString",
      :label => "MyString"
    ))
  end

  it "renders the edit minor_system form" do
    render

    assert_select "form[action=?][method=?]", minor_system_path(@minor_system), "post" do

      assert_select "input#minor_system_name[name=?]", "minor_system[name]"

      assert_select "input#minor_system_label[name=?]", "minor_system[label]"
    end
  end
end
