require 'rails_helper'

RSpec.describe "examinations/new", :type => :view do
  before(:each) do
    assign(:examination, Examination.new(
      :title => "MyString",
      :state => 1,
      :exam_id => 1,
      :clinician => 1
    ))
  end

  it "renders new examination form" do
    render

    assert_select "form[action=?][method=?]", examinations_path, "post" do

      assert_select "input#examination_title[name=?]", "examination[title]"

      assert_select "input#examination_state[name=?]", "examination[state]"

      assert_select "input#examination_exam_id[name=?]", "examination[exam_id]"

      assert_select "input#examination_clinician[name=?]", "examination[clinician]"
    end
  end
end
