require 'rails_helper'

RSpec.describe "diagnoses/edit", :type => :view do
  before(:each) do
    @diagnosis = assign(:diagnosis, Diagnosis.create!(
      :name => "MyString",
      :label => "MyString",
      :code => "MyString"
    ))
  end

  it "renders the edit diagnosis form" do
    render

    assert_select "form[action=?][method=?]", diagnosis_path(@diagnosis), "post" do

      assert_select "input#diagnosis_name[name=?]", "diagnosis[name]"

      assert_select "input#diagnosis_label[name=?]", "diagnosis[label]"

      assert_select "input#diagnosis_code[name=?]", "diagnosis[code]"
    end
  end
end
