require 'rails_helper'
require 'via_api.rb'


# the actual unit testing spec
RSpec.describe 'VIA_API::SchedulingService', cpp: true do

  before do
    login_via_response = Rails.root.join("spec/support/via_api/login_via_response.xml").read
    make_appointment_response = Rails.root.join("spec/support/via_api/make_appointment_response.xml").read
    cancel_appointment_response = Rails.root.join("spec/support/via_api/cancel_appointment_response.xml").read

    url  = VIA_API::VIA_SCHEDULING_ENDPOINT_URL
    login_url = VIA_API::VIA_EMR_ENDPOINT_URL
    stub_request(:post, login_url).with { |request| request.body.include?("loginVIA") }.to_return(status: 200, body: login_via_response)
    stub_request(:post, url).with { |request| request.body.include?("makeAppointment") }.to_return(status: 200, body: make_appointment_response)
    stub_request(:post, url).with { |request| request.body.include?("cancelAppointment") }.to_return(status: 200, body: cancel_appointment_response)

    @test_patient = VIA_API::Models::Veteran.new( {:first_name=>"FAITH",
                                               :middle_name=>"K",
                                               :last_name=>"AARSVOLD",
                                               :date_of_birth=>"07/16/1942",
                                               :address=>["712 S OAK",nil,nil],
                                               :city=>"KIMBALL",
                                               :county=>"65",
                                               :state=>"NEBRASKA",
                                               :zip=>"69145",
                                               :ssn=>"101012294",
                                               :gender=>"F",
                                               :age=>"74",
                                               :marital_status=>"MARRIED",
                                               :patient_name=>"AARSVOLD,FAITH K",
                                               :mpi_pid=>"1009609054",
                                               :mpi_checksum=>"897943",
                                               :local_pid=>"7177262",
                                               :location=>{:id=>"80", :name=>"C SURGERY", :specialty=>{:text=>"4"}, :room=>"2112", :bed=>"1", :ask_for_check_in=>false},
                                               :cwad=>"AD",
                                               :restricted=>false,
                                               :admit_timestamp=>"20160609.165547",
                                               :service_connected=>false,
                                               :sc_percent=>"0",
                                               :inpatient=>false,
                                               :confidentiality=>{:tag=>"0"},
                                               :needs_means_test=>false,
                                               :patient_flags=>{:count=>"0"},
                                               :cmor_site_id=>"442",
                                               :active_insurance=>
                                                "Pt Insur^Patient has active Insurance^\nCompany ID:                   7168777.868\nCompany Name:                 BLUE CROSS/BS WY\nCompany Address:              PO BOX 2266\n                              CHEYENNE, WYOMING 82003-2266\nPhone Number:                 634-1393\nCoordination of Benefits:     PRIMARY insurer\nPolicy Name:                  6033 - KIESOW\nPolicy Reimbursable:          YES\nEffective Date:               Jan 01, 1995\nExpiration Date:              \nSubscriber Relationship to Patient:     SPOUSE\nSubscriber Name:                        AARSVOLD,ELI\nSubscriber ID:                          R026770010\nPharmacy Coverage:            NO\nOutpatient Coverage:          YES\nInpatient Coverage:           YES\nGroup Number:                 GRP NUM 6033\nPatient Relationship to Subscriber:     SPOUSE",
                                               :is_test_patient=>false,
                                               :has_insurance=>false,
                                               :patient_type=>"NON-VETERAN (OTHER)",
                                               :is_veteran=>false,
                                               :is_locally_assigned_mpi_pid=>false,
                                               :sites=>{:count=>"1", :sites=>{:site_to=>{:sitecode=>"516", :name=>"Bay Pines, FL"}}},
                                               :team=>{:attending_name=>"AUDELHUK,CECILIA C", :name=>"GREEN TEAM"}} )
    params = { access_code: "access", verify_code: "verify", site_code: "site" }
    @vista_session = { vista: VIA_API.authenticate(params)}
    @test_clinic_id = "325"
  end

  describe 'methods', cpp: true do
    it 'Performs the make_appointment operation' do
      appointment_time = Time.new(2017, 1, 1, 15, 0, 0)  # 1/1/17 3:00 PM
      response = VIA_API::SchedulingService.make_appointment(@test_patient, @test_clinic_id, nil, appointment_time, 'TEST BOOK NOTE', @vista_session[:vista])
      expect(response.first.appointment_type).to eq("REGULAR")
      expect(response.first.purpose).to eq("SCHEDULED VISIT")
      expect(response.first.appointment_length.to_i).to eq(60)
      expect(response.first.book_notes).to eq("TEST BOOK NOTE")  # NOTE: matches make_appointment_response, not param above
    end

    it 'Performs the cancel_appointment operation' do
      response = VIA_API::SchedulingService.cancel_appointment(20170707.103, @test_patient, 1, 1921, 'test reason', 'test remarks', @vista_session[:vista])
      expect(response[0][:purpose].to_i).to eq(1)
      expect(response[0][:reason]).to eq("test reason")
    end
  end
end
