require "rails_helper"

RSpec.describe ReferralsController, :type => :routing do
  describe "routing" do

    it "routes to #index", cpp: true do
      expect(:get => "/referrals").to route_to("referrals#index")
    end

    it "routes to #new", cpp: true do
      expect(:get => "/referrals/new").to route_to("referrals#new")
    end

    it "routes to #show", cpp: true do
      expect(:get => "/referrals/1").to route_to("referrals#show", :id => "1")
    end

    it "routes to #edit", cpp: true do
      expect(:get => "/referrals/1/edit").to route_to("referrals#edit", :id => "1")
    end

    it "routes to #create", cpp: true do
      expect(:post => "/referrals").to route_to("referrals#create")
    end

    it "routes to #update", cpp: true do
      expect(:put => "/referrals/1").to route_to("referrals#update", :id => "1")
    end

    it "routes to #destroy", cpp: true do
      expect(:delete => "/referrals/1").to route_to("referrals#destroy", :id => "1")
    end

  end
end
