require "rails_helper"

RSpec.describe MinorSystemsController, :type => :routing do
  describe "routing" do

    it "routes to #index" do
      expect(:get => "/minor_systems").to route_to("minor_systems#index")
    end

    it "routes to #new" do
      expect(:get => "/minor_systems/new").to route_to("minor_systems#new")
    end

    it "routes to #show" do
      expect(:get => "/minor_systems/1").to route_to("minor_systems#show", :id => "1")
    end

    it "routes to #edit" do
      expect(:get => "/minor_systems/1/edit").to route_to("minor_systems#edit", :id => "1")
    end

    it "routes to #create" do
      expect(:post => "/minor_systems").to route_to("minor_systems#create")
    end

    it "routes to #update" do
      expect(:put => "/minor_systems/1").to route_to("minor_systems#update", :id => "1")
    end

    it "routes to #destroy" do
      expect(:delete => "/minor_systems/1").to route_to("minor_systems#destroy", :id => "1")
    end

  end
end
