ENV['RAILS_ENV'] = 'test' # Don't dop this: ENV['RAILS_ENV'] ||= 'test' The database cleaner doesn't operate as expected in other environments.

require 'require_all'
require 'spec_helper'
require 'simplecov'
require 'simplecov-json'
require 'simplecov-rcov'
require 'factory_bot'
require 'shoulda-matchers'

SimpleCov.formatters = [
   SimpleCov::Formatter::HTMLFormatter,
   SimpleCov::Formatter::JSONFormatter,
   SimpleCov::Formatter::RcovFormatter
]

SimpleCov.start 'rails' do
  minimum_coverage 1   # was 70
end
# This file is copied to spec/ when you run 'rails generate rspec:install'
require File.expand_path("../../config/environment", __FILE__)
require 'rspec/rails'
require 'capybara/rspec'
require 'xml'

require 'webmock/rspec'
WebMock.disable_net_connect!(allow_localhost: true)

require 'paper_trail/frameworks/rspec'

include Warden::Test::Helpers
Warden.test_mode!

# Requires supporting ruby files with custom matchers and macros, etc, in
# spec/support/ and its subdirectories. Files matching `spec/**/*_spec.rb` are
# run as spec files by default. This means that files in spec/support that end
# in _spec.rb will both be required and run as specs, causing the specs to be
# run twice. It is recommended that you do not name files matching this glob to
# end with _spec.rb. You can configure this pattern with with the --pattern
# option on the command line or in ~/.rspec, .rspec or `.rspec-local`.
Dir[Rails.root.join("spec/support/**/*.rb")].each { |f| require f }

# Checks for pending migrations before tests are run.
# If you are not using ActiveRecord, you can remove this line.
ActiveRecord::Migration.check_pending! if defined?(ActiveRecord::Migration)

RSpec.configure do |config|
  # Remove this line if you're not using ActiveRecord or ActiveRecord fixtures
  config.fixture_path = "#{::Rails.root}/spec/fixtures"

  # If you're not using ActiveRecord, or you'd prefer not to run each of your
  # examples within a transaction, remove the following line or assign false
  # instead of true.
  config.use_transactional_fixtures = true

  # RSpec Rails can automatically mix in different behaviours to your tests
  # based on their file location, for example enabling you to call `get` and
  # `post` in specs under `spec/controllers`.
  #
  # You can disable this behaviour by removing the line below, and instead
  # explicitly tag your specs with their type, e.g.:
  #
  #     RSpec.describe UsersController, :type => :controller do
  #       # ...
  #     end
  #
  # The different available types are documented in the features, such as in
  # https://relishapp.com/rspec/rspec-rails/docs
  config.infer_spec_type_from_file_location!

  config.include Capybara::DSL
  config.include FactoryBot::Syntax::Methods
  config.include Devise::TestHelpers, type: :controller

  STATIC_DATA_TABLES = [
    'care_categories', 'consultation_orders', 'consultation_statuses', 'consultation_types',
    'medical_specialties', 'other_health_insurances', 'referral_document_types',
    'referral_reasons', 'referral_types', 'visns', 'sites', 'diagnosis_codes',
    'referral_statuses', 'examination_states', 'exam_request_states', 'clarification_types'
  ]

  config.before(:suite) do
    DatabaseCleaner.clean_with(:truncation, :except => STATIC_DATA_TABLES)
  end

  config.before(:each) do
    DatabaseCleaner.strategy = :transaction
  end

  config.before(:each, :js => true) do
    DatabaseCleaner.strategy = :truncation, {:except => STATIC_DATA_TABLES}
  end

  config.before(:context) do
    DatabaseCleaner.start
  end

  config.after(:context) do
    DatabaseCleaner.clean
  end

  config.before(:each) do
    DatabaseCleaner.start
  end

  config.after(:each) do
    DatabaseCleaner.clean
  end

end

# RSpec one-liners that test common Rails functionality.
Shoulda::Matchers.configure do |config|
  config.integrate do |with|
    with.test_framework :rspec
    with.library :rails
  end
end

# EXAMS is a Hash of {"exam_title" => exam_fml_form}
EXAMS = Hash[Dir[Rails.root.join("app/exams/*.yml")].map do |f|
  exam = FML::Form.new(File.read(f))
  [exam.title, exam]
end]

ActiveRecord::Base.skip_callbacks = true

Capybara.javascript_driver = :webkit
