# == Schema Information
#
# Table name: visns
#
#  id         :integer          not null, primary key
#  sequence   :string
#  title      :string
#  deleted_at :datetime
#

require 'rails_helper'

RSpec.describe Visn, :type => :model do

  context "Associations", cpp: true do
    it { should have_many(:facilities) }
  end

  describe "ParanoidModelTest", cpp: true do
    it_behaves_like 'a Paranoid model'
  end

  it "should have pre-loaded VISNs", cpp: true do
    expect(Visn.count).to be > 0
  end

  context "Methods" do

    it "should have titles that start with the region number and end with the title", cpp: true do
      Visn.all.each do |visn|
        expect(visn.title).to start_with(visn.region.to_s)
        expect(visn.title).to end_with(visn.name)
      end

    end

  end
end
