# == Schema Information
#
# Table name: sites
#
#  id              :integer          not null, primary key
#  name            :string
#  address         :string
#  city            :string
#  state           :string
#  country         :string
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  access_requests :string           default([]), is an Array
#  role_requests   :string           default([]), is an Array
#  site_station_number     :string
#  zip_code        :string
#  deleted_at      :datetime
#

require 'rails_helper'

RSpec.describe Site, :type => :model do
  context "Associations", cui: true do
    it { should have_many(:site_role_sets) }
    it { should have_many(:examinations) }
    it { should have_many(:exam_requests) }
    it { should have_many(:users).through(:site_role_sets) }
  end
end
