# == Schema Information
#
# Table name: referral_notes
#
#  id          :integer          not null, primary key
#  content     :json
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#  referral_id :integer
#

require 'rails_helper'

RSpec.describe ReferralNote, :type => :model do

  context "Associations", cpp: true do
    it { should belong_to(:referral) }
  end

  context 'validations' do
    it "should not raise error when referrals notes are present in content", cpp: true do
      referral_note = create(:referral_note)
      expect(referral_note.valid?).to be_truthy
    end

    it "should raise error when referrals notes are not present in content", cpp: true do
      referral_note = ReferralNote.new
      expect(referral_note.valid?).to be_falsey
    end

  end

  context "methods" do
    let(:referral_note) { create(:referral_note, content: {user: "Joe Bob Billy Boy", notes: "Test Referral Notes XYZ"}) }

    it "should get user from Referral Note content", cpp: true do
      expect(referral_note.user).to eq("Joe Bob Billy Boy")
    end

    it "should get notes from Referral Note content", cpp: true do
      expect(referral_note.notes).to eq("Test Referral Notes XYZ")
    end

  end

end
