# == Schema Information
#
# Table name: question_modifiers
#
#  id          :integer          not null, primary key
#  name        :string
#  label       :string
#  mod_type    :string
#  list_values :string           default([]), is an Array
#  html        :text
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#

require 'rails_helper'

RSpec.describe QuestionModifier, :type => :model do
  context "Associations", cui: true do
    it { should have_many(:qm_assignments).dependent(:delete_all) }
    it { should have_many(:general_questions).through(:qm_assignments) }
  end
end
