# == Schema Information
#
# Table name: providers_users
#
#  id          :integer          not null, primary key
#  provider_id :integer
#  user_id     :integer
#

require 'rails_helper'

RSpec.describe ProvidersUser, :type => :model do
  
  context "Associations", cpp: true do
    it { should belong_to(:provider) }
    it { should belong_to(:user) }
  end

  context "methods" do
    before :context do
      @vha_user = create(:vha_user)
      @non_vha_user = create(:community_provider)
      @provider = create(:provider)
    end

    it "should validate a non-vha user", cpp: true do
      providers_user = ProvidersUser.create(user: @non_vha_user, provider: @provider)
      expect(providers_user).to be_valid
    end

    it "should not validate a vha user", cpp: true do
      providers_user = ProvidersUser.create(user: @vha_user, provider: @provider)
      expect(providers_user).to be_invalid
    end
  end
end
