# == Schema Information
#
# Table name: minor_systems
#
#  id              :integer          not null, primary key
#  name            :string
#  label           :string
#  created_at      :datetime         not null
#  updated_at      :datetime         not null
#  major_system_id :integer
#

require 'rails_helper'

RSpec.describe MinorSystem, :type => :model do
  context "Associations", cui: true do
    it { should have_many(:symptoms) }
    it { should have_many(:diagnoses) }
    it { should have_many(:general_questions) }

    it { should belong_to(:major_system) }
  end
end
