# == Schema Information
#
# Table name: facilities
#
#  id      :integer          not null, primary key
#  name    :string
#  content :json
#  visn_id :integer
#

require 'rails_helper'

RSpec.describe Facility, :type => :model do

  before do
  	@facility = create(:facility)
  end

  context "Associtations", cpp:true do
    it { should belong_to(:visn) }
    it { should have_many(:providers) }
  end

  context "Methods" do
    it "should return the value of visn region prepended name", cpp: true do
  	  result_string = @facility.visn_id.to_s + ": " + @facility.name
  	  expect(@facility.visn_region_prepended_name).to eq result_string
  	end
  end

end
