# == Schema Information
#
# Table name: examinations
#
#  id                                              :integer          not null, primary key
#  title                                           :string
#  exam_date                                       :datetime
#  state                                           :integer
#  exam_id                                         :integer
#  clinician                                       :integer
#  created_at                                      :datetime         not null
#  updated_at                                      :datetime         not null
#  site_id                                         :integer
#  examination_state_id                            :integer
#  active                                          :boolean
#  examfile                                        :string
#  exam_request_id                                 :integer
#  purpose                                         :string
#  evaluation_id                                   :integer
#  examination_state_start_date                    :datetime
#  claim_folder_reviewed                           :boolean
#  reviewed_not_indicated                          :boolean
#  reviewed_military_service_treatment_records     :boolean
#  reviewed_military_service_personnel_records     :boolean
#  reviewed_military_enlistment_examination        :boolean
#  reviewed_military_separation_examination        :boolean
#  reviewed_military_post_deployment_questionnaire :boolean
#  reviewed_dod_form_214_separation_documents      :boolean
#  reviewed_vha_treatment_records                  :boolean
#  reviewed_civilian_medical_records               :boolean
#  reviewed_interviews_with_collateral_witnesses   :boolean
#  reviewed_at                                     :datetime
#  reviewed_by                                     :integer
#  interview                                       :text
#  plan                                            :text
#  examfiles                                       :string           default([]), is an Array
#  claim_id                                        :integer
#  cancellation_reason                             :text
#  identifier                                      :string
#  acknowledged                                    :boolean
#  clinician_acknowledged                          :boolean
#

require 'rails_helper'

RSpec.describe Examination, :type => :model do
  context "Associations", cui: true do
    it { should belong_to(:examination_state) }
    it { should belong_to(:site) }
    it { should belong_to(:claim) }
    it { should belong_to(:parent).
         class_name('ExamRequest').
         with_foreign_key('exam_request_id')
    }
    it { should belong_to(:clinician_user).
         class_name('User').
         with_foreign_key('clinician')
    }
    it { should belong_to(:exam_request) }

    it { should have_one(:full_body_evaluation).
         dependent(:destroy)
    }
    it { should have_one(:examination_review_questionnaire) }

    it { should have_and_belong_to_many(:contentions) }

    it { should have_many(:examination_schedules) }
    it { should have_many(:examination_notes) }
  end
end
