# == Schema Information
#
# Table name: diagnoses
#
#  id                    :integer          not null, primary key
#  name                  :string
#  label                 :string
#  code                  :string
#  diagnosis_modifier_id :integer
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#  minor_system_id       :integer
#

require 'rails_helper'

RSpec.describe Diagnosis, :type => :model do
  context "Associations", cpp: true do
    it { should have_many(:dm_assignments).
         dependent(:delete_all)
    }
    it { should have_many(:diagnosis_modifiers).
         through(:dm_assignments)
    }
    it { should have_many(:symp_diag_relations).
         dependent(:delete_all)
    }
    it { should have_many(:symptoms).
         through(:symp_diag_relations)
    }
    it { should have_many(:dbq_informations).
         through(:diagnoses_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:diagnoses_dbq_informations) }
    it { should belong_to(:minor_system) }
  end
end
