# == Schema Information
#
# Table name: diagnosis_modifiers
#
#  id          :integer          not null, primary key
#  name        :string
#  label       :string
#  mod_type    :string
#  list_values :string           default([]), is an Array
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#

require 'rails_helper'

RSpec.describe DiagnosisModifier, :type => :model do
  context "Associations", cpp: true do
    it { should have_many(:dm_assignments).
         dependent(:delete_all)
    }
    it { should have_many(:diagnoses).
         through(:dm_assignments)
    }
  end
end
