## == Schema DbqInformation
#
#  Table name: dbq_informations
#  identifier            :string
#  title                 :string
#  created_at            :datetime         not null
#  updated_at            :datetime         not null
#

require 'rails_helper'

RSpec.describe DbqInformation, :type => :model do

  context "Associations", cui: true do
    it { should have_many(:boilerplate_messages).
         through(:boilerplate_messages_dbq_informations)
    }
    it { should have_many(:boilerplate_messages_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:contentions).
         through(:contentions_dbq_informations)
    }
    it { should have_many(:contentions_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:symptoms).
         through(:symptoms_dbq_informations)
    }
    it { should have_many(:symptoms_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:diagnoses).
         through(:diagnoses_dbq_informations)
    }
    it { should have_many(:diagnoses_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:general_questions).
         through(:general_questions_dbq_informations)
    }
    it { should have_many(:general_questions_dbq_informations).
         dependent(:destroy)
    }
  end
	context "Creation of Dbq informations object and associations" do

		before(:context) do
      @dbq_information = create(:dbq_information)
      @dbq_information.general_questions_dbq_informations.each {|gq| gq.update_columns(position: gq.id)}
      @dbq_information.diagnoses_dbq_informations.each {|d| d.update_columns(position: d.id)}
      @dbq_information.symptoms_dbq_informations.each {|s| s.update_columns(position: s.id)}
	  end

	  it "DBQ Information should have 3 associated symptoms, diagnoses, and general questions", cui: true do
      expect(@dbq_information.symptoms.count).to eq 3
      expect(@dbq_information.diagnoses.count).to eq 3
      expect(@dbq_information.general_questions.count).to eq 3
    end

    it "test the order of the general question has many through association position attribute", cui: true do
   		gq_pos = @dbq_information.gq_dbq_info_order_asc.pluck(:position)
   		expect(gq_pos).to eq gq_pos.sort
  	end

    it "test the order of the diagnoses has many through association position attribute", cui: true do
   		dia_pos = @dbq_information.diagnoses_dbq_info_order_asc.pluck(:position)
   		expect(dia_pos).to eq dia_pos.sort
  	end

    it "test the order of the symptoms has many through association position attribute", cui: true do
   		sym_pos = @dbq_information.symptoms_dbq_info_order_asc.pluck(:position)
   		expect(sym_pos).to eq sym_pos.sort
   	end

	end
end
