# == Schema Information
#
# Table name: consultation_comments
#
#  id                    :integer         not null, primary key
#  comments              :text            not null
#  consultation          :references      not null, index: true, foreign: true
#  user                  :references      not null, index: true, foreign: true
#  created_at            :datetime
#  updated_at            :datetime
#

require 'rails_helper'

RSpec.describe ConsultationComment, type: :model, cpp: true do

  context "Associations" do
    it { should belong_to(:consultation) }
    it { should belong_to(:user) }
  end

  context "Methods" do

    let!(:consultation) {create(:consultation)}
    let!(:user) {create(:user)}
    let!(:consultation_comment) {create(:consultation_comment, consultation: consultation, user: user)}

    it "consultation has comments" do
      expect(consultation.comments.first.comments).to eq "Factory Girl Comment"
     end
    end
  end
