## == Schema BoilerplateMessage
#
#  Table name: boilerplate_messages
#
#  name                  :string
#  content               :string
#  created_at            :datetime         not null
#  updated_at            :datetime         not null

require 'rails_helper'

RSpec.describe BoilerplateMessage, :type => :model do

  context "Associations", cui: true do
    it { should have_many(:boilerplate_messages_dbq_informations).
         dependent(:destroy)
    }
    it { should have_many(:dbq_informations).
         through(:boilerplate_messages_dbq_informations)
    }
  end

  context "when validating boilerplate messages" do

    it "should not create boilerplate messages with blank namess", cui: true do
      expect {
        create(:boilerplate_message, name: nil)
      }.to raise_error(ActiveRecord::RecordInvalid)
    end

    it "should not create boilerplate messages with blank content", cui: true do
      expect {
        create(:boilerplate_message, content: nil)
      }.to raise_error(ActiveRecord::RecordInvalid)
    end
  end

  context "Methods" do

    it "should create a unique dbq information record when passed a dbq information object", cpp: true do
      boilerplate_message = create(:boilerplate_message)
      dbq_information = create(:dbq_information)
      boilerplate_message.creates_a_unique_dbq_information_association_with(dbq_information)
      expect(BoilerplateMessagesDbqInformation.where(boilerplate_message_id: boilerplate_message.id, dbq_information_id: dbq_information.id).count).to eq 1
    end
  end

end
