require 'rails_helper'

RSpec.describe ApplicationHelper, :type => :helper  do
  describe "Array of Strings will accept a string or array of strings" do 
    before :each do 
      @h1 = {:Era => ["Gulf War", "Vietnam War"]}
      @h2 = {:PeacetimeEra => "Peacetime"}
    end
    it "and will return an array of strings", cui: true do 
      expect(array_of_strings(@h1[:Era])).to be_instance_of(Array)
      expect(array_of_strings(@h2[:PeacetimeEra])).to be_instance_of(Array)
      expect(array_of_strings(@h2[:PeacetimeEra])).to eq(["Peacetime"])
      expect(array_of_strings(nil)).to eq([])
    end
  end

  describe "Array of hashes will accept a hash or an array of hashes" do
    before :each do 
      @h1 = {:DbqRequest=>[{:name=>"DIAGNOSIS_HIP_DIAGNOSIS"}, {:name=>"DIAGNOSIS_SHOULDER_DIAGNOSIS"}, {:name=>"DIAGNOSIS_LEG_DIAGNOSIS"}]}
      @h2 = {:DbqRequest=>{:name=>"DBQ PSYCH Mental Disorders"}}
    end
    it "and will return an array of hashes", cui: true do 
      expect(array_of_hashes(@h1[:DbqRequest])).to be_instance_of(Array)
      expect(array_of_hashes(@h1[:DbqRequest]).length).to eq(3)
      expect(array_of_hashes(@h2[:DbqRequest])).to be_instance_of(Array)
      expect(array_of_hashes(@h2[:DbqRequest]).length).to eq(1)
      expect(array_of_hashes(nil).length).to eq(0)
    end
  end
end