# == Schema Information
#
# Table name: referral_notes
#
#  id          :integer          not null, primary key
#  content     :json
#  created_at  :datetime         not null
#  updated_at  :datetime         not null
#  referral_id :integer
#

FactoryBot.define do

  get_content = -> (n) do
     veteran_id = FactoryBot.create(:veteran).id
     consultation_id = FactoryBot.create(:consultation).id
     referral_id = FactoryBot.create(:referral).id
     {
       veteran_id: veteran_id,
       consultation_id: consultation_id,
       referral_id: referral_id,
       referral_note_number: n,
       user: "Joe Bob Billy Boy",
       notes: "This is referral_note ##{n} for referral ##{referral_id} for consultation ##{consultation_id} for veteran ##{veteran_id}"
     }
  end

  factory :referral_note do
    referral { Referral.first || association(:referral) }
    sequence(:content)     {|n| get_content.call(n) }
  end

end