# == Schema Information
#
# Table name: referral_appointments
#
#  id               :integer          not null, primary key
#  content          :json
#  created_at       :datetime         not null
#  updated_at       :datetime         not null
#  referral_id      :integer
#  appointment_time :datetime
#  added_to_cprs_at :datetime
#  added_to_cprs_id :integer
#

FactoryBot.define do

  get_content = -> (n) do
    {
       referral_appointment_number: n,
       appointment_type: "Appointment Type #{n} for referral",
       scheduled_by: "Joe Bob Billy Boy",
       notes: "This is referral_note ##{n}."
    }
  end

  # Default referral appointment: use default (first) referral, a default
  # appointment time that should not trigger special conditions such as needs_reminder,
  # and with "Added to CPRS" unchecked.
  factory :referral_appointment do
    referral           { association(:referral) }
    appointment_time   { 7.days.from_now }
    sequence(:content) {|n| get_content.call(n) }
  end

  factory :referral_appointment_added_to_cprs, class: ReferralAppointment do
    referral           { association(:referral) }
    appointment_time   { 7.days.from_now }
    sequence(:content) {|n| get_content.call(n) }
    added_to_cprs_id   { create(:vha_user).id }
    added_to_cprs_at   { 1.day.ago }
  end

end
