# == Schema Information
#
# Table name: examinations
#
#  id                                              :integer          not null, primary key
#  title                                           :string
#  exam_date                                       :datetime
#  state                                           :integer
#  exam_id                                         :integer
#  clinician                                       :integer
#  created_at                                      :datetime         not null
#  updated_at                                      :datetime         not null
#  site_id                                         :integer
#  examination_state_id                            :integer
#  active                                          :boolean
#  examfile                                        :string
#  exam_request_id                                 :integer
#  purpose                                         :string
#  evaluation_id                                   :integer
#  examination_state_start_date                    :datetime
#  claim_folder_reviewed                           :boolean
#  reviewed_not_indicated                          :boolean
#  reviewed_military_service_treatment_records     :boolean
#  reviewed_military_service_personnel_records     :boolean
#  reviewed_military_enlistment_examination        :boolean
#  reviewed_military_separation_examination        :boolean
#  reviewed_military_post_deployment_questionnaire :boolean
#  reviewed_dod_form_214_separation_documents      :boolean
#  reviewed_vha_treatment_records                  :boolean
#  reviewed_civilian_medical_records               :boolean
#  reviewed_interviews_with_collateral_witnesses   :boolean
#  reviewed_at                                     :datetime
#  reviewed_by                                     :integer
#  interview                                       :text
#  plan                                            :text
#  examfiles                                       :string           default([]), is an Array
#  claim_id                                        :integer
#  cancellation_reason                             :text
#  identifier                                      :string
#  acknowledged                                    :boolean
#  clinician_acknowledged                          :boolean
#

FactoryBot.define do
  factory :examination_state do
    name 'In Progress'
    code 'IN_PROGRESS'
  end

  factory :exam_state_scheduled, class: ExaminationState do
    name 'Schedule'
    code 'SCHEDULED'
  end

  factory :contention do
    name "Leg injury"
    claim
    # examination
  end

  factory :examination do
    claim
    site
    exam_request
    identifier "examination_identifier"
  end

  # factory :examination do
  #   sequence(:title) { |n| "Exam #{n}"}
    
  #   factory :examination_with_contentions do
  #     transient do
  #       contentions_count 5
  #     end

  #     after(:create) do |examination, evaluator|
  #       create_list(:contention, evaluator.contentions_count, examinations: [examination])
  #     end
  #   end

  # end
end
