require 'rails_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

RSpec.describe GeneralQuestionsController, :type => :controller do

  # This should return the minimal set of attributes required to create a valid
  # GeneralQuestion. As you add validations to GeneralQuestion, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) {
    skip("Add a hash of attributes valid for your model")
  }

  let(:invalid_attributes) {
    skip("Add a hash of attributes invalid for your model")
  }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # GeneralQuestionsController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all general_questions as @general_questions", cui: true do
      general_question = GeneralQuestion.create! valid_attributes
      get :index, {}, valid_session
      expect(assigns(:general_questions)).to eq([general_question])
    end
  end

  describe "GET show" do
    it "assigns the requested general_question as @general_question", cui: true do
      general_question = GeneralQuestion.create! valid_attributes
      get :show, {:id => general_question.to_param}, valid_session
      expect(assigns(:general_question)).to eq(general_question)
    end
  end

  describe "GET new" do
    it "assigns a new general_question as @general_question", cui: true do
      get :new, {}, valid_session
      expect(assigns(:general_question)).to be_a_new(GeneralQuestion)
    end
  end

  describe "GET edit" do
    it "assigns the requested general_question as @general_question", cui: true do
      general_question = GeneralQuestion.create! valid_attributes
      get :edit, {:id => general_question.to_param}, valid_session
      expect(assigns(:general_question)).to eq(general_question)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new GeneralQuestion", cui: true do
        expect {
          post :create, {:general_question => valid_attributes}, valid_session
        }.to change(GeneralQuestion, :count).by(1)
      end

      it "assigns a newly created general_question as @general_question", cui: true do
        post :create, {:general_question => valid_attributes}, valid_session
        expect(assigns(:general_question)).to be_a(GeneralQuestion)
        expect(assigns(:general_question)).to be_persisted
      end

      it "redirects to the created general_question", cui: true do
        post :create, {:general_question => valid_attributes}, valid_session
        expect(response).to redirect_to(GeneralQuestion.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved general_question as @general_question", cui: true do
        post :create, {:general_question => invalid_attributes}, valid_session
        expect(assigns(:general_question)).to be_a_new(GeneralQuestion)
      end

      it "re-renders the 'new' template", cui: true do
        post :create, {:general_question => invalid_attributes}, valid_session
        expect(response).to render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      let(:new_attributes) {
        skip("Add a hash of attributes valid for your model")
      }

      it "updates the requested general_question", cui: true do
        general_question = GeneralQuestion.create! valid_attributes
        put :update, {:id => general_question.to_param, :general_question => new_attributes}, valid_session
        general_question.reload
        skip("Add assertions for updated state")
      end

      it "assigns the requested general_question as @general_question", cui: true do
        general_question = GeneralQuestion.create! valid_attributes
        put :update, {:id => general_question.to_param, :general_question => valid_attributes}, valid_session
        expect(assigns(:general_question)).to eq(general_question)
      end

      it "redirects to the general_question", cui: true do
        general_question = GeneralQuestion.create! valid_attributes
        put :update, {:id => general_question.to_param, :general_question => valid_attributes}, valid_session
        expect(response).to redirect_to(general_question)
      end
    end

    describe "with invalid params" do
      it "assigns the general_question as @general_question", cui: true do
        general_question = GeneralQuestion.create! valid_attributes
        put :update, {:id => general_question.to_param, :general_question => invalid_attributes}, valid_session
        expect(assigns(:general_question)).to eq(general_question)
      end

      it "re-renders the 'edit' template", cui: true do
        general_question = GeneralQuestion.create! valid_attributes
        put :update, {:id => general_question.to_param, :general_question => invalid_attributes}, valid_session
        expect(response).to render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested general_question", cui: true do
      general_question = GeneralQuestion.create! valid_attributes
      expect {
        delete :destroy, {:id => general_question.to_param}, valid_session
      }.to change(GeneralQuestion, :count).by(-1)
    end

    it "redirects to the general_questions list", cui: true do
      general_question = GeneralQuestion.create! valid_attributes
      delete :destroy, {:id => general_question.to_param}, valid_session
      expect(response).to redirect_to(general_questions_url)
    end
  end

end
