require 'rails_helper'

# This spec was generated by rspec-rails when you ran the scaffold generator.
# It demonstrates how one might use RSpec to specify the controller code that
# was generated by Rails when you ran the scaffold generator.
#
# It assumes that the implementation code is generated by the rails scaffold
# generator.  If you are using any extension libraries to generate different
# controller code, this generated spec may or may not pass.
#
# It only uses APIs available in rails and/or rspec-rails.  There are a number
# of tools you can use to make these specs even more expressive, but we're
# sticking to rails and rspec-rails APIs to keep things simple and stable.
#
# Compared to earlier versions of this generator, there is very limited use of
# stubs and message expectations in this spec.  Stubs are only used when there
# is no simpler way to get a handle on the object needed for the example.
# Message expectations are only used when there is no simpler way to specify
# that an instance is receiving a specific message.

RSpec.describe ExaminationsController, :type => :controller do

  # This should return the minimal set of attributes required to create a valid
  # Examination. As you add validations to Examination, be sure to
  # adjust the attributes here as well.
  let(:valid_attributes) {
    skip("Add a hash of attributes valid for your model")
  }

  let(:invalid_attributes) {
    skip("Add a hash of attributes invalid for your model")
  }

  # This should return the minimal set of values that should be in the session
  # in order to pass any filters (e.g. authentication) defined in
  # ExaminationsController. Be sure to keep this updated too.
  let(:valid_session) { {} }

  describe "GET index" do
    it "assigns all examinations as @examinations", cui: true do
      examination = Examination.create! valid_attributes
      get :index, {}, valid_session
      expect(assigns(:examinations)).to eq([examination])
    end
  end

  describe "GET show" do
    it "assigns the requested examination as @examination", cui: true do
      examination = Examination.create! valid_attributes
      get :show, {:id => examination.to_param}, valid_session
      expect(assigns(:examination)).to eq(examination)
    end
  end

  describe "GET new" do
    # it "assigns a new examination as @examination" do
    #   get :new, {}, valid_session
    #   expect(assigns(:examination)).to be_a_new(Examination)
    # end
  end

  describe "GET edit" do
    it "assigns the requested examination as @examination", cui: true do
      examination = Examination.create! valid_attributes
      get :edit, {:id => examination.to_param}, valid_session
      expect(assigns(:examination)).to eq(examination)
    end
  end

  describe "POST create" do
    describe "with valid params" do
      it "creates a new Examination", cui: true do
        expect {
          post :create, {:examination => valid_attributes}, valid_session
        }.to change(Examination, :count).by(1)
      end

      it "assigns a newly created examination as @examination", cui: true do
        post :create, {:examination => valid_attributes}, valid_session
        expect(assigns(:examination)).to be_a(Examination)
        expect(assigns(:examination)).to be_persisted
      end

      it "redirects to the created examination", cui: true do
        post :create, {:examination => valid_attributes}, valid_session
        expect(response).to redirect_to(Examination.last)
      end
    end

    describe "with invalid params" do
      it "assigns a newly created but unsaved examination as @examination", cui: true do
        post :create, {:examination => invalid_attributes}, valid_session
        expect(assigns(:examination)).to be_a_new(Examination)
      end

      it "re-renders the 'new' template", cui: true do
        post :create, {:examination => invalid_attributes}, valid_session
        expect(response).to render_template("new")
      end
    end
  end

  describe "PUT update" do
    describe "with valid params" do
      let(:new_attributes) {
        skip("Add a hash of attributes valid for your model")
      }

      it "updates the requested examination", cui: true do
        examination = Examination.create! valid_attributes
        put :update, {:id => examination.to_param, :examination => new_attributes}, valid_session
        examination.reload
        skip("Add assertions for updated state")
      end

      it "assigns the requested examination as @examination", cui: true do
        examination = Examination.create! valid_attributes
        put :update, {:id => examination.to_param, :examination => valid_attributes}, valid_session
        expect(assigns(:examination)).to eq(examination)
      end

      it "redirects to the examination", cui: true do
        examination = Examination.create! valid_attributes
        put :update, {:id => examination.to_param, :examination => valid_attributes}, valid_session
        expect(response).to redirect_to(examination)
      end
    end

    describe "with invalid params" do
      it "assigns the examination as @examination", cui: true do
        examination = Examination.create! valid_attributes
        put :update, {:id => examination.to_param, :examination => invalid_attributes}, valid_session
        expect(assigns(:examination)).to eq(examination)
      end

      it "re-renders the 'edit' template", cui: true do
        examination = Examination.create! valid_attributes
        put :update, {:id => examination.to_param, :examination => invalid_attributes}, valid_session
        expect(response).to render_template("edit")
      end
    end
  end

  describe "DELETE destroy" do
    it "destroys the requested examination", cui: true do
      examination = Examination.create! valid_attributes
      expect {
        delete :destroy, {:id => examination.to_param}, valid_session
      }.to change(Examination, :count).by(-1)
    end

    it "redirects to the examinations list", cui: true do
      examination = Examination.create! valid_attributes
      delete :destroy, {:id => examination.to_param}, valid_session
      expect(response).to redirect_to(examinations_url)
    end
  end

end
