class CuiDeavtivateUserAccount
  def initialize(params)
    @current_script = params[:current_script]
    @my_class_name = self.class.name
    @environment = params[:environment]
    @max_inactive_period = params[:max_inactive_period].to_s.scan(/\d/).
                                                        join('').to_i
    @pid = params[:pid]
  end

  def deactivate_users(max_inactive_period)
    cutoff_date = max_inactive_period.days.ago.at_beginning_of_day
    User.where( authorization_state: 'authorized' ).
        where.not( last_sign_in_at: nil ).
        where( ["last_sign_in_at < ?", cutoff_date] ).
        update_all( authorization_state: 'none'  )
    true
  end

  def run
    User.connection unless ActiveRecord::Base.connected?
    if ActiveRecord::Base.connected?
      rv = deactivate_users(@max_inactive_period)
    else
      msg = "#{self.class}\##{__method__} #{@pid}" \
            "ERROR: Not connected to the database."
            Rails.logger.fatal("#{msg}")
      puts  error_msg msg
      rv = false
    end
    rv
  end
end
