# lib/tasks/prep.rake

namespace :prep do

  desc "Prepare the database via db:reset or db:migrate and/or db:seed based upon system environment variables"
  task :db do
    puts "Preparing the database on #{ENV['DBHOST']} ..."
    Rake::Task["db:pgpass"].invoke

    if DBRESET  &&  ('development' == Rails.env)
      Rake::Task["db:reset"].invoke
    elsif DBMIGRATE
      Rake::Task["db:migrate"].invoke
      if DBSEED
        Rake::Task["db:seed"].invoke
      end
    elsif DBSEED
      Rake::Task["db:seed"].invoke
    end
  end

end # namespace :prep do