# tasks related to deploying the app and maintaining consistency among
# inter-region codebases and other devops sundries


namespace :devops do

  desc "Log the deployment"
  task log_deployment: :environment do
    require 'active_support'
    require 'logger'

    DEPLOYMENT_HISTORY="log/deployment_history.log".freeze
    DEPLOYMENT_TIMESTAMP_FORMAT = '%F %T'.freeze  #ex: yyyy-mm-dd hh-mm-ss
    CODE_VERSION = `git rev-parse --abbrev-ref HEAD`

    log = ActiveSupport::Logger.new(DEPLOYMENT_HISTORY)
    start_time = Time.now.strftime(DEPLOYMENT_TIMESTAMP_FORMAT)

    log.info "#{start_time} -- Started with branch/tag #{CODE_VERSION}"

  end

end
