require 'awesome_print'

namespace :admin do
  desc 'Add test users to database.'

  task add_test_users: :environment do

    ADMIN = "admin"
    SITE_ADMIN = "site_admin"
    TRIAGE = "triage"
    SCHEDULER = "scheduler"
    CLINICIAN = "clinician"

    def create_or_query(email, first_name, last_name, site)
      user_from_db = User.create(
              email: email,
              password: "Tester!12345",
              authorization_state: "authorized",
              first_name: first_name,
              last_name: last_name) unless User.exists?(email: email)
      if (!user_from_db.present?)
        #Query the record from the database
        user_from_db = User.find_by_email(email)
      end
      if (!user_from_db.site_role_sets.present?)
        user_from_db.add_site(site)
      end
      user_from_db
    end

    def assign_site_role(user, role)
      if (role.present? and user.present?)
        if (role == ADMIN)
          user.roles = ["app_admin", "site_user"]
          user.save
        elsif (role == SITE_ADMIN)
          user.site_role_sets[0].admin=true
        elsif (role == TRIAGE)
          user.site_role_sets[0].triage=true
        elsif (role == SCHEDULER)
          user.site_role_sets[0].scheduling=true
        elsif (role == CLINICIAN)
          user.site_role_sets[0].clinician=true
        end
        user.site_role_sets[0].save
      end
    end

 #   ARGV.each {|a| task a.to_sym do ; end }
 #   site = ARGV[1]
 #   roles  = ARGV[2]

    site_from_db = Site.find_by_name("QTC")

    if (site_from_db == nil)
      puts "Invalid site ::: " + site.to_s
      puts "Please select one from the list ::: [QTC, VES, VetFed, Atlanta VA Medical Center, Chicago Medical Center]"
    else

      cui_admin1 = create_or_query("cui.admin1@gmail.com", "CUI", "Admin1", site_from_db)
      assign_site_role(cui_admin1, ADMIN)
      puts("CUI Admin1 created.")

      cui_admin2 = create_or_query("cui.admin2@gmail.com", "CUI", "Admin2", site_from_db)
      assign_site_role(cui_admin2, ADMIN)
      puts("CUI Admin2 created.")

      cui_site_admin1 = create_or_query("cui.siteadmin1@gmail.com", "CUI", "Site Admin1", site_from_db)
      assign_site_role(cui_site_admin1, SITE_ADMIN)
      puts("CUI Site Admin1 created.")

      cui_site_admin2 = create_or_query("cui.siteadmin2@gmail.com", "CUI", "Site Admin2", site_from_db)
      assign_site_role(cui_site_admin2, SITE_ADMIN)
      puts("CUI Site Admin2 created.")

      cui_triage1 = create_or_query("cui.triage1@gmail.com", "CUI", "Triage1", site_from_db)
      assign_site_role(cui_triage1, TRIAGE)
      puts("CUI Triage1 created.")

      cui_triage2 = create_or_query("cui.triage2@gmail.com", "CUI", "Triage2", site_from_db)
      assign_site_role(cui_triage2, TRIAGE)
      puts("CUI Triage2 created.")

      cui_scheduler1 = create_or_query("cui.scheduler1@gmail.com", "CUI", "Scheduler1", site_from_db)
      assign_site_role(cui_scheduler1, SCHEDULER)
      puts("CUI Scheduler1 created.")

      cui_scheduler2 = create_or_query("cui.scheduler2@gmail.com", "CUI", "Scheduler2", site_from_db)
      assign_site_role(cui_scheduler2, SCHEDULER)
      puts("CUI Scheduler2 created.")

      cui_clinician1 = create_or_query("cui.clinician1@gmail.com", "CUI", "Clinician1", site_from_db)
      assign_site_role(cui_clinician1, CLINICIAN)
      puts("CUI Clinician1 created.")

      cui_clinician2 = create_or_query("cui.clinician2@gmail.com", "CUI", "Clinician2", site_from_db)
      assign_site_role(cui_clinician2, CLINICIAN)
      puts("CUI Clinician2 created.")

      cui_user1 = create_or_query("cui.user1@gmail.com", "CUI", "User1", site_from_db)
      assign_site_role(cui_user1, ADMIN)
      assign_site_role(cui_user1, TRIAGE)
      assign_site_role(cui_user1, SCHEDULER)
      assign_site_role(cui_user1, CLINICIAN)
      puts("CUI User1 created.")

      cui_user2 = create_or_query("cui.user2@gmail.com", "CUI", "User2", site_from_db)
      assign_site_role(cui_user2, ADMIN)
      assign_site_role(cui_user2, TRIAGE)
      assign_site_role(cui_user2, SCHEDULER)
      assign_site_role(cui_user2, CLINICIAN)
      puts("CUI User2 created.")

      vetfed_site = Site.find_by_name("VetFed")
      vetfed_user1 = create_or_query("vetfed.user1@gmail.com", "VetFed", "User1", site_from_db)
      assign_site_role(vetfed_user1, ADMIN)
      assign_site_role(vetfed_user1, TRIAGE)
      assign_site_role(vetfed_user1, SCHEDULER)
      assign_site_role(vetfed_user1, CLINICIAN)
      puts("VetFed User1 created.")

      vetfed_user2 = create_or_query("vetfed.user2@gmail.com", "VetFed", "User2", site_from_db)
      assign_site_role(vetfed_user2, ADMIN)
      assign_site_role(vetfed_user2, TRIAGE)
      assign_site_role(vetfed_user2, SCHEDULER)
      assign_site_role(vetfed_user2, CLINICIAN)
      puts("VetFed User1 created.")
    end
  end
end
