# lib/date_helpers.rb

module DateHelpers
  VALID_CLASSES = [String, Date]

  class << self

    def create_range(from_thing, to_thing='', string_format='%m/%d/%Y')

      raise "Invalid Parameters '#{from_thing}' and '#{to_thing}'" unless VALID_CLASSES.include?(from_thing.class) &&
                                                                          VALID_CLASSES.include?(to_thing.class)

      if String == from_thing.class
        from_thing = Date.strptime(from_thing, string_format)
      end

      to_thing = from_thing if to_thing.empty?

      if String == to_thing.class
        to_thing = Date.strptime(to_thing, string_format)
      end

      return from_thing..to_thing

    end # def create_range(from_thing, to_thing='', string_format='%m/%d/%Y')

  end # class << self
end # module DateHelpers