#!/usr/bin/env bash

cd /home/app/webapp

date > /tmp/db_init.log

echo " " >> /tmp/db_init.log
echo "Setup database config for rails app..." >> /tmp/db_init.log
echo " " >> /tmp/db_init.log

DBHOST=REDACTED
DBPORT=PORT
DBNAME="REDACTED"
DBUSER="REDACTED"
DBPSWD="REDACTED"

if [[ -n $ENV_DBHOST ]]; then
    DBHOST=$ENV_DBHOST
fi

if [[ -n $1 ]]; then
    DBHOST=$1
fi

if [[ -n $2 ]]; then
    DBPORT=$2
fi

if [[ -n $3 ]]; then
    DBNAME=$3
fi

if [[ -n $4 ]]; then
    DBUSER=$4
fi

if [[ -n $5 ]]; then
    DBPSWD=$5
fi

cd /home/app/webapp/config
su app -c "./setupdbconfig.sh $DBHOST $DBPORT $DBNAME $DBUSER $DBPSWD" >> /tmp/db_init.log
cd /home/app/webapp

echo " " >> /tmp/db_init.log
echo "Reset Database..." >> /tmp/db_init.log
echo " " >> /tmp/db_init.log
su app -c "bundle exec rake db:reset" >> /tmp/db_init.log

echo " " >> /tmp/db_init.log
echo "Migrate Database..." >> /tmp/db_init.log
echo " " >> /tmp/db_init.log
su app -c "bundle exec rake db:migrate" >> /tmp/db_init.log

echo " " >> /tmp/db_init.log
echo "Sync Specs..." >> /tmp/db_init.log
echo " " >> /tmp/db_init.log
su app -c "bundle exec rake specs:sync" >> /tmp/db_init.log

echo " " >> /tmp/db_init.log
echo "Seed Database..." >> /tmp/db_init.log
echo " " >> /tmp/db_init.log
su app -c "bundle exec rake db:seed" >> /tmp/db_init.log

date >> /tmp/db_init.log
